/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.agg;

import com.alicloud.openservices.tablestore.core.protocol.SearchAggregationBuilder;
import com.alicloud.openservices.tablestore.core.utils.ValueUtil;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationType;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PercentilesAggregation
implements Aggregation {
    private AggregationType aggregationType = AggregationType.AGG_PERCENTILES;
    private String aggName;
    private String fieldName;
    private List<Double> percentiles;
    private ColumnValue missing;

    public PercentilesAggregation() {
    }

    private PercentilesAggregation(Builder builder) {
        this.setAggName(builder.aggName);
        this.setFieldName(builder.fieldName);
        this.setPercentiles(builder.percentiles);
        this.setMissing(builder.missing);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getAggName() {
        return this.aggName;
    }

    @Override
    public AggregationType getAggType() {
        return this.aggregationType;
    }

    @Override
    public ByteString serialize() {
        return SearchAggregationBuilder.buildPercentilesAggregation(this).toByteString();
    }

    public PercentilesAggregation setAggName(String aggName) {
        this.aggName = aggName;
        return this;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public PercentilesAggregation setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public List<Double> getPercentiles() {
        return this.percentiles;
    }

    public PercentilesAggregation setPercentiles(List<Double> percentiles) {
        this.percentiles = percentiles;
        return this;
    }

    public ColumnValue getMissing() {
        return this.missing;
    }

    public PercentilesAggregation setMissing(ColumnValue missing) {
        this.missing = missing;
        return this;
    }

    public static final class Builder
    implements AggregationBuilder {
        private String aggName;
        private String fieldName;
        private List<Double> percentiles;
        private ColumnValue missing;

        public Builder aggName(String aggName) {
            this.aggName = aggName;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder percentiles(Double ... percentile) {
            if (this.percentiles == null) {
                this.percentiles = new ArrayList<Double>();
            }
            this.percentiles.addAll(Arrays.asList(percentile));
            return this;
        }

        public Builder percentiles(List<Double> percentileList) {
            if (this.percentiles == null) {
                this.percentiles = new ArrayList<Double>();
            }
            this.percentiles.addAll(percentileList);
            return this;
        }

        public Builder missing(Object missing) {
            this.missing = ValueUtil.toColumnValue(missing);
            return this;
        }

        @Override
        public PercentilesAggregation build() {
            return new PercentilesAggregation(this);
        }
    }
}

