/**
 * Copyright (C) Alibaba Cloud Computing, 2012
 * All rights reserved.
 * 
 * 版权所有 （C）阿里巴巴云计算，2012
 */

package com.aliyun.oss;


/**
 * 该异常在对开放存储数据服务（Open Storage Service）访问失败时抛出。
 */
public class OSSException extends ServiceException {

    private static final long serialVersionUID = -1979779664334663173L;
    
    private String resourceType;
    private String header;
    private String method;
    
    public OSSException() {
        super();
    }

    public OSSException(String errorMessage) {
        super(errorMessage);
    }

    public OSSException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
    }

    public OSSException(String errorMessage, String errorCode, String requestId,
            String hostId, String header, String resourceType, String method) {
    	this(errorMessage, errorCode, requestId, hostId, header, resourceType, method, null);
    }
    
    public OSSException(String errorMessage, String errorCode, String requestId,
            String hostId, String header, String resourceType, String method, Throwable cause) {
    	super(errorMessage, errorCode, requestId, hostId, cause);
        this.resourceType = resourceType;
        this.header = header;
        this.method = method;
    }

    public String getResourceType() {
        return resourceType;
    }

    public String getHeader() {
    	return header;
    }

	public String getMethod() {
		return method;
	}
	
	@Override
    public String getMessage() {
    	return super.getMessage() 
    			+ (getResourceType() == null ? "" : "\n[ResourceType]: " + getResourceType())
    			+ (getHeader() == null ? "" : "\n[Header]: " + getHeader())
    			+ (getMethod() == null ? "" : "\n[Method]: " + getMethod());
    }
}