package com.aliyun.oss.common.auth;

/**
 * Default implementation of {@link CredentialsProvider}. 
 */
public class DefaultCredentialProvider implements CredentialsProvider {
	
	private volatile Credentials creds;
	
	public DefaultCredentialProvider(Credentials creds) {
		setCredentials(creds);
	}
	
	public DefaultCredentialProvider(String accessKeyId, String secretAccessKey) {
		checkCredentials(accessKeyId, secretAccessKey);
		setCredentials(new DefaultCredentials(accessKeyId, secretAccessKey));
	}
	
	@Override
	public synchronized void setCredentials(Credentials creds) {
		if (creds == null) {
			throw new InvalidCredentialsException("creds should not be null.");
		}
		
		checkCredentials(creds.getAccessKeyId(), creds.getSecretAccessKey());
		this.creds = creds;
	}

	@Override
	public Credentials getCredentials() {
		if (this.creds == null) {
			throw new InvalidCredentialsException("Invalid credentials");
		}
		
		return this.creds;
	}
	
	private static void checkCredentials(String accessKeyId, String secretAccessKey) {
		if (accessKeyId == null || accessKeyId.equals("")) {
            throw new InvalidCredentialsException("Access key id should not be null or empty.");
        }
       
		if (secretAccessKey == null || secretAccessKey.equals("")) {
            throw new InvalidCredentialsException("Secret access key should not be null or empty.");
        }
	}

}
