package com.aliyun.oss.common.auth;

/**
 * Default implementation of {@link Credentials}.
 */
public class DefaultCredentials implements Credentials {

    private final String accessKeyId;
    private final String secretAccessKey;

    public DefaultCredentials(String accessKeyId, String secretAccessKey) {
        if (accessKeyId == null || accessKeyId.equals("")) {
            throw new InvalidCredentialsException("Access key id should not be null or empty.");
        }
        if (secretAccessKey == null || accessKeyId.equals("")) {
            throw new InvalidCredentialsException("Secret access key should not be null or empty.");
        }

        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
    }

	@Override
	public String getAccessKeyId() {
		return accessKeyId;
	}

	@Override
	public String getSecretAccessKey() {
		return secretAccessKey;
	}
}
