/**
 * Copyright (C) Alibaba Cloud Computing, 2012
 * All rights reserved.
 * 
 * 版权所有 （C）阿里巴巴云计算，2012
 */

package com.aliyun.oss.common.utils;

import java.util.List;

import com.aliyun.oss.internal.OSSConstants;

/**
 * Utils for common coding.
 */
public class CodingUtils {
	
	private static ResourceManager rm = ResourceManager.getInstance(OSSConstants.RESOURCE_NAME_COMMON);

	public static void assertParameterNotNull(Object param, String paramName) {
		if (param == null) {
			throw new NullPointerException(rm.getFormattedString(
					"ParameterIsNull", paramName));
		}
	}

	public static void assertStringNotNullOrEmpty(String param, String paramName) {
		assertParameterNotNull(param, paramName);
		assert (param != null);
		if (param.trim().length() == 0) {
			throw new IllegalArgumentException(rm.getFormattedString(
					"ParameterStringIsEmpty", paramName));
		}
	}
	
	@SuppressWarnings("rawtypes")
	public static void assertListNotNullOrEmpty(List param, String paramName){
		assertParameterNotNull(param, paramName);
		if (param.size() == 0) {
			throw new IllegalArgumentException(rm.getFormattedString(
					"ParameterListIsEmpty", paramName));
		}
	}
	
	public static boolean isNullOrEmpty(String value) {
		return value == null || value.length() == 0;
	}
	
	public static void assertTrue(boolean condition, String message) {
		if (!condition) {
			throw new IllegalArgumentException(message);
		}
	}
	
	public static  boolean checkParamRange(long param, long from, boolean leftInclusive, 
			long to, boolean rightInclusive) {
		
		if (leftInclusive && rightInclusive) {	// [from, to]
			if (from <= param && param <= to) {
				return true;
			} else {
				return false;
			}
		} else if (leftInclusive && !rightInclusive) {  // [from, to)
			if (from <= param && param < to) {
				return true;
			} else {
				return false;
			}
		} else if (!leftInclusive && !rightInclusive) {	// (from, to)
			if (from < param && param < to) {
				return true;
			} else {
				return false;
			}
		} else {	 // (from, to]
			if (from < param && param <= to) {
				return true;
			} else {
				return false;
			}
		}
	}
}
