/**
 * Copyright (C) Alibaba Cloud Computing, 2012
 * All rights reserved.
 * 
 * 版权所有 （C）阿里巴巴云计算，2012
 */
package com.aliyun.oss.common.utils;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;

import com.aliyun.oss.ClientErrorCode;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.internal.model.OSSErrorResult;

/**
 * A simple factory used for creating instances of <code>ClientException</code> 
 * and <code>OSSException</code>.
 */
public class ExceptionFactory {
	
    public static ClientException createNetworkException(IOException ex) {
        String requestId = "Unknown";
        String errorCode = ClientErrorCode.UNKNOWN;
        
        if (ex instanceof SocketTimeoutException) {
            errorCode = ClientErrorCode.SOCKET_TIMEOUT;
        } else if (ex instanceof SocketException) {
        	errorCode = ClientErrorCode.SOCKET_EXCEPTION;
        } else if (ex instanceof ConnectTimeoutException) {
            errorCode = ClientErrorCode.CONNECTION_TIMEOUT;
        } else if (ex instanceof UnknownHostException) {
           errorCode = ClientErrorCode.UNKNOWN_HOST;
        } else if (ex instanceof HttpHostConnectException) {
        	errorCode = ClientErrorCode.CONNECTION_REFUSED;
        } else if (ex instanceof ClientProtocolException) {
        	Throwable cause = ex.getCause();
        	if (cause instanceof NonRepeatableRequestException) {
        		errorCode = ClientErrorCode.NONREPEATABLE_REQUEST;
        		return new ClientException(requestId, errorCode, cause.getMessage(), cause);
        	}
        }
        
        return new ClientException(ex.getMessage(), errorCode, requestId, ex);
    }
    
    public static ClientException createInvalidResponseException(String requestId, String message, Throwable cause) {
    	return new ClientException(message, ClientErrorCode.INVALID_RESPONSE, requestId, cause);
    }
    
    public static OSSException createOSSException(OSSErrorResult errorResult) {
        return new OSSException(
                errorResult.Message != null ? errorResult.Message : null,
                errorResult.Code != null ? errorResult.Code : null,
                errorResult.RequestId != null ? errorResult.RequestId : null,
                errorResult.HostId != null ? errorResult.HostId : null,
                errorResult.Header != null ? errorResult.Header : null,
                errorResult.ResourceType != null ? errorResult.ResourceType : null,
                errorResult.Method != null ? errorResult.Method : null);
    }

    
    public static OSSException createOSSException(String requestId, String errorCode, String message) {
        return new OSSException(message, errorCode, requestId, null, null, null, null);
    }
}
