/**
 * Copyright (C) Alibaba Cloud Computing, 2012
 * All rights reserved.
 * 
 * 版权所有 （C）阿里巴巴云计算，2012
 */

package com.aliyun.oss.internal;

/**
 * Miscellaneous constants used for oss client service.
 */
public final class OSSConstants {
	
    public static final String DEFAULT_OSS_ENDPOINT = "http://oss.aliyuncs.com";

    public static final String DEFAULT_CHARSET_NAME = "utf-8";
    public static final String DEFAULT_XML_ENCODING = "utf-8";
    
    public static final String DEFAULT_OBJECT_CONTENT_TYPE = "application/octet-stream";
    
    public static final int KB = 1024;
    public static final int DEFAULT_BUFFER_SIZE = 8 * KB;
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 128 * KB;
    
    public static final long DEFAULT_FILE_SIZE_LIMIT = 5 * 1024 * 1024 * 1024L;

    public static final String RESOURCE_NAME_COMMON = "common";
    public static final String RESOURCE_NAME_OSS = "oss";
    
    public static final int OBJECT_NAME_MAX_LENGTH = 1024;
}
