/**
 * Copyright (C) Alibaba Cloud Computing, 2012
 * All rights reserved.
 * 
 * 版权所有 （C）阿里巴巴云计算，2012
 */
package com.aliyun.oss.model;

import java.util.ArrayList;
import java.util.List;

/**
 * 表示{@link Bucket}的http referer信息。
 * <p>
 * 该配置会指明是否允许空的http referer，以及能够访问{@link Bucket}的白名单，常用于防盗链。
 * </p>
 *
 */
public class BucketReferer {
	private boolean allowEmptyReferer = true;
	private List<String> refererList = new ArrayList<String>();

	public BucketReferer() {
		
	}
	
	public BucketReferer(boolean allowEmptyReferer, List<String> refererList) {
		setAllowEmptyReferer(allowEmptyReferer);
		setRefererList(refererList);
	}
	
	@Deprecated
	public boolean allowEmpty() {
		return this.allowEmptyReferer;
	}
	
	public boolean isAllowEmptyReferer() {
		return allowEmptyReferer;
	}

	public void setAllowEmptyReferer(boolean allowEmptyReferer) {
		this.allowEmptyReferer = allowEmptyReferer;
	}

	public List<String> getRefererList() {
		return refererList;
	}
	
	public void setRefererList(List<String> refererList) {
		this.refererList.clear();
		if (refererList != null && !refererList.isEmpty()) {
			this.refererList.addAll(refererList);
		}
	}
	
	public void clearRefererList() {
		this.refererList.clear();
	}
}
