package com.aliyun.oss.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Response for Delete multiple objects.
 */
public class DeleteObjectsResult {
	
	/* Successfully deleted objects */
	private final List<String> deletedObjects = new ArrayList<String>();

	public DeleteObjectsResult(List<String> deletedObjects) {
		if (deletedObjects != null && deletedObjects.size() > 0) {
			this.deletedObjects.addAll(deletedObjects);
		}
	}
	
	public List<String> getDeletedObjects() {
		return deletedObjects;
	}
	
	public void setDeletedObjects(List<String> deletedObjects) {
		this.deletedObjects.clear();
		this.deletedObjects.addAll(deletedObjects);
	}
}
