package com.aliyun.oss.model;

import java.io.File;
import java.io.InputStream;

public class PutObjectRequest {
    
	private String bucketName;
    private String key;
    
    private File file;
    private InputStream inputStream;
    
    private ObjectMetadata metadata;
    
    public PutObjectRequest(String bucketName, String key, File file) {
        this.bucketName = bucketName;
        this.key = key;
        this.file = file;
    }

    public PutObjectRequest(String bucketName, String key, InputStream input, ObjectMetadata metadata) {
        this.bucketName = bucketName;
        this.key = key;
        this.inputStream = input;
        this.metadata = metadata;
    }

	public String getBucketName() {
		return bucketName;
	}

	public void setBucketName(String bucketName) {
		this.bucketName = bucketName;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}

	public InputStream getInputStream() {
		return inputStream;
	}

	public void setInputStream(InputStream inputStream) {
		this.inputStream = inputStream;
	}

	public ObjectMetadata getMetadata() {
		return metadata;
	}

	public void setMetadata(ObjectMetadata metadata) {
		this.metadata = metadata;
	}
	
	public PutObjectRequest withMetadata(ObjectMetadata metadata) {
		setMetadata(metadata);
		return this;
	}
}
