/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.HttpClientFactory;
import com.aliyun.oss.common.comm.HttpRequestFactory;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.HttpUtil;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

public class DefaultServiceClient
extends ServiceClient {
    private static HttpClientFactory httpClientFactory = new HttpClientFactory();
    private static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    private HttpClient httpClient;

    public DefaultServiceClient(ClientConfiguration config) {
        super(config);
        this.httpClient = httpClientFactory.createHttpClient(this.config);
    }

    @Override
    public ResponseMessage sendRequestCore(ServiceClient.Request request, ExecutionContext context) throws IOException {
        HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request, context);
        HttpResponse apacheHttpResponse = null;
        try {
            apacheHttpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
        }
        catch (IOException ex) {
            httpRequest.abort();
            throw ExceptionFactory.createNetworkException(ex);
        }
        return DefaultServiceClient.buildResponse(request, apacheHttpResponse);
    }

    private static ResponseMessage buildResponse(ServiceClient.Request request, HttpResponse apacheHttpResponse) throws IOException {
        ResponseMessage response = new ResponseMessage(request);
        response.setUrl(request.getUri());
        if (apacheHttpResponse.getStatusLine() != null) {
            response.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        }
        if (apacheHttpResponse.getEntity() != null) {
            response.setContent(apacheHttpResponse.getEntity().getContent());
        }
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            if ("Content-Length".equals(header.getName())) {
                response.setContentLength(Long.parseLong(header.getValue()));
            }
            response.addHeader(header.getName(), header.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(response.getHeaders());
        return response;
    }

    @Override
    protected RetryStrategy getDefaultRetryStrategy() {
        return new DefaultRetryStrategy();
    }

    private static class DefaultRetryStrategy
    extends RetryStrategy {
        private DefaultRetryStrategy() {
        }

        @Override
        public boolean shouldRetry(Exception ex, RequestMessage request, ResponseMessage response, int retries) {
            int statusCode;
            if (ex instanceof ClientException) {
                String errorCode = ((ClientException)ex).getErrorCode();
                if (errorCode.equals("ConnectionTimeout") || errorCode.equals("SocketTimeout") || errorCode.equals("ConnectionRefused") || errorCode.equals("UnknownHost") || errorCode.equals("SocketException")) {
                    return true;
                }
                if (errorCode.equals("NonRepeatableRequest")) {
                    return false;
                }
            }
            return response != null && ((statusCode = response.getStatusCode()) == 500 || statusCode == 503);
        }
    }
}

