/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.parser.JAXBResponseParser;
import com.aliyun.oss.common.parser.ResponseParseException;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.ResourceManager;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.model.OSSErrorResult;

public class OSSErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage response) throws OSSException, ClientException {
        if (response.isSuccessful()) {
            return;
        }
        String requestId = response.getRequestId();
        int statusCode = response.getStatusCode();
        if (response.getContent() == null) {
            if (statusCode == 404) {
                throw ExceptionFactory.createOSSException(requestId, "NoSuchKey", "Not Found");
            }
            if (statusCode == 304) {
                throw ExceptionFactory.createOSSException(requestId, "NotModified", "Not Modified");
            }
            if (statusCode == 412) {
                throw ExceptionFactory.createOSSException(requestId, "PreconditionFailed", "Precondition Failed");
            }
            throw ExceptionFactory.createInvalidResponseException(requestId, ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), null);
        }
        JAXBResponseParser parser = new JAXBResponseParser(OSSErrorResult.class);
        try {
            try {
                OSSErrorResult errorResult = (OSSErrorResult)parser.parse(response);
                throw ExceptionFactory.createOSSException(errorResult);
            }
            catch (ResponseParseException e) {
                throw ExceptionFactory.createInvalidResponseException(requestId, ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), e);
            }
        }
        catch (Throwable throwable) {
            OSSUtils.safeCloseResponse(response);
            throw throwable;
        }
    }
}

