/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.model.Grant;
import com.aliyun.oss.model.Grantee;
import com.aliyun.oss.model.Owner;
import com.aliyun.oss.model.Permission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class AccessControlList
implements Serializable {
    private static final long serialVersionUID = 211267925081748283L;
    private HashSet<Grant> grants = new HashSet();
    private Owner owner = null;

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void grantPermission(Grantee grantee, Permission permission) {
        if (grantee == null || permission == null) {
            throw new NullPointerException();
        }
        this.grants.add(new Grant(grantee, permission));
    }

    public void revokeAllPermissions(Grantee grantee) {
        if (grantee == null) {
            throw new NullPointerException();
        }
        ArrayList<Grant> grantsToRemove = new ArrayList<Grant>();
        for (Grant g : this.grants) {
            if (!g.getGrantee().equals(g)) continue;
            grantsToRemove.add(g);
        }
        this.grants.removeAll(grantsToRemove);
    }

    public Set<Grant> getGrants() {
        return this.grants;
    }

    public String toString() {
        return "AccessControlList [owner=" + this.owner + ", grants=" + this.getGrants() + "]";
    }
}

