/*
 * Decompiled with CFR 0.152.
 */
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.OSSObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class AppendObjectSample {
    private static String endpoint = "*** Provide OSS endpoint ***";
    private static String accessKeyId = "*** Provide your AccessKeyId ***";
    private static String accessKeySecret = "*** Provide your AccessKeySecret ***";
    private static String bucketName = "*** Provide bucket name ***";
    private static String key = "*** Provide key ***";

    public static void main(String[] args) throws IOException {
        OSSClient client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            try {
                String content = "Thank you for using Aliyun Object Storage Service";
                ByteArrayInputStream instream = new ByteArrayInputStream(content.getBytes());
                Long firstPosition = 0L;
                System.out.println("Begin to append object at position(" + firstPosition + ")");
                AppendObjectResult appendObjectResult = client.appendObject(new AppendObjectRequest(bucketName, key, instream).withPosition(0L));
                System.out.println("\tNext position=" + appendObjectResult.getNextPosition() + ", CRC64=" + appendObjectResult.getObjectCRC64() + "\n");
                Long nextPosition = appendObjectResult.getNextPosition();
                System.out.println("Continue to append object at last position(" + nextPosition + "):");
                appendObjectResult = client.appendObject(new AppendObjectRequest(bucketName, key, AppendObjectSample.createTempFile()).withPosition(nextPosition));
                System.out.println("\tNext position=" + appendObjectResult.getNextPosition() + ", CRC64=" + appendObjectResult.getObjectCRC64());
                OSSObject object = client.getObject(bucketName, key);
                System.out.println("\tObject type=" + object.getObjectMetadata().getObjectType() + "\n");
                object.getObjectContent().close();
                System.out.println("Deleting an appendable object");
                client.deleteObject(bucketName, key);
            }
            catch (OSSException oe) {
                System.out.println("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
                System.out.println("Error Message: " + oe.getErrorCode());
                System.out.println("Error Code:       " + oe.getErrorCode());
                System.out.println("Request ID:      " + oe.getRequestId());
                System.out.println("Host ID:           " + oe.getHostId());
                client.shutdown();
            }
            catch (ClientException ce) {
                System.out.println("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
                System.out.println("Error Message: " + ce.getMessage());
                client.shutdown();
            }
        }
        finally {
            client.shutdown();
        }
    }

    private static File createTempFile() throws IOException {
        File file = File.createTempFile("oss-java-sdk-", ".txt");
        file.deleteOnExit();
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
        writer.write("abcdefghijklmnopqrstuvwxyz\n");
        writer.write("0123456789011234567890\n");
        ((Writer)writer).close();
        return file;
    }
}

