/*
 * Decompiled with CFR 0.152.
 */
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeleteObjectsSample {
    private static String endpoint = "*** Provide OSS endpoint ***";
    private static String accessKeyId = "*** Provide your AccessKeyId ***";
    private static String accessKeySecret = "*** Provide your AccessKeySecret ***";
    private static String bucketName = "*** Provide bucket name ***";

    public static void main(String[] args) throws IOException {
        OSSClient client = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            try {
                String content = "Thank you for using Aliyun Object Storage Service";
                String keyPrefix = "MyObjectKey";
                ArrayList<String> keys = new ArrayList<String>();
                int i = 0;
                while (i < 100) {
                    String key = "MyObjectKey" + i;
                    ByteArrayInputStream instream = new ByteArrayInputStream("Thank you for using Aliyun Object Storage Service".getBytes());
                    client.putObject(bucketName, key, instream);
                    System.out.println("Succeed to put object " + key);
                    keys.add(key);
                    ++i;
                }
                System.out.println();
                System.out.println("\nDeleting all objects:");
                DeleteObjectsResult deleteObjectsResult = client.deleteObjects(new DeleteObjectsRequest(bucketName).withKeys(keys));
                List<String> deletedObjects = deleteObjectsResult.getDeletedObjects();
                for (String object : deletedObjects) {
                    System.out.println("\t" + object);
                }
                System.out.println();
            }
            catch (OSSException oe) {
                System.out.println("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
                System.out.println("Error Message: " + oe.getErrorCode());
                System.out.println("Error Code:       " + oe.getErrorCode());
                System.out.println("Request ID:      " + oe.getRequestId());
                System.out.println("Host ID:           " + oe.getHostId());
                client.shutdown();
            }
            catch (ClientException ce) {
                System.out.println("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
                System.out.println("Error Message: " + ce.getMessage());
                client.shutdown();
            }
        }
        finally {
            client.shutdown();
        }
    }
}

