/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss;

import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.Grant;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.MultipartUploadListing;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PartListing;
import com.aliyun.oss.model.PartSummary;
import com.aliyun.oss.model.Permission;
import com.aliyun.oss.utils.ResourceUtils;
import java.io.InputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class OSSResponseParserTest {
    private static final String FILE_FOLDER = "oss";

    private InputStream getInputStream(String filename) throws Exception {
        return ResourceUtils.getTestInputStream("oss/" + filename);
    }

    @Test
    public void testParserGetBucketLocation() throws Exception {
        String filename = "getBucketLocation.xml";
        InputStream in = this.getInputStream(filename);
        String location = ResponseParsers.parseGetBucketLocation(in);
        Assert.assertEquals((Object)"oss-cn-qingdao-a", (Object)location);
    }

    @Test
    public void testParseListObjects() throws Exception {
        String filename = "listObjects.xml";
        InputStream in = this.getInputStream(filename);
        ObjectListing objectListing = ResponseParsers.parseListObjects(in);
        Assert.assertFalse((boolean)objectListing.isTruncated());
        Assert.assertEquals((Object)"pacjux7y1b86pmtu7g8d6b7z-test-bucket", (Object)objectListing.getBucketName());
        Assert.assertNull((Object)objectListing.getPrefix());
        Assert.assertNull((Object)objectListing.getMarker());
        Assert.assertEquals((long)100L, (long)objectListing.getMaxKeys());
        Assert.assertNull((Object)objectListing.getDelimiter());
        for (OSSObjectSummary summary : objectListing.getObjectSummaries()) {
            Assert.assertEquals((Object)"pacjux7y1b86pmtu7g8d6b7z-test-object", (Object)summary.getKey());
            Assert.assertEquals((Object)DateUtil.parseIso8601Date("2012-02-09T01:49:38.000Z"), (Object)summary.getLastModified());
            Assert.assertEquals((long)10L, (long)summary.getSize());
            Assert.assertEquals((Object)"9BF156C2C16BB90B9EC81C96FE37EF1B", (Object)summary.getETag());
            Assert.assertEquals((Object)"Standard", (Object)summary.getStorageClass());
            Assert.assertEquals((Object)"51744", (Object)summary.getOwner().getId());
            Assert.assertEquals((Object)"51744", (Object)summary.getOwner().getDisplayName());
        }
        in.close();
    }

    @Test
    public void testParseGetBucketAcl() throws Exception {
        String filename = "getBucketAcl.xml";
        InputStream in = this.getInputStream(filename);
        AccessControlList accessControlList = ResponseParsers.parseGetBucketAcl(in);
        Assert.assertEquals((Object)"51744", (Object)accessControlList.getOwner().getId());
        Assert.assertEquals((Object)"51744", (Object)accessControlList.getOwner().getDisplayName());
        Assert.assertEquals((Object)((Object)Permission.FullControl), (Object)((Object)((Grant)accessControlList.getGrants().toArray()[0]).getPermission()));
        in.close();
    }

    @Test
    public void testParseListBucket() throws Exception {
        String filename = "listBucket.xml";
        InputStream in = this.getInputStream(filename);
        BucketList bucketList = ResponseParsers.parseListBucket(in);
        Assert.assertEquals(null, (Object)bucketList.getPrefix());
        Assert.assertEquals(null, (Object)bucketList.getMarker());
        Assert.assertEquals(null, (Object)bucketList.getMaxKeys());
        Assert.assertEquals((Object)false, (Object)bucketList.isTruncated());
        Assert.assertEquals(null, (Object)bucketList.getNextMarker());
        List<Bucket> buckets = bucketList.getBucketList();
        Bucket bucket1 = buckets.get(0);
        Assert.assertEquals((Object)"51744", (Object)bucket1.getOwner().getId());
        Assert.assertEquals((Object)"51744", (Object)bucket1.getOwner().getDisplayName());
        Assert.assertEquals((Object)"pacjux7y1b86pmtu7g8d6b7z-test-bucket", (Object)bucket1.getName());
        Assert.assertEquals((Object)DateUtil.parseIso8601Date("2012-02-09T01:49:38.000Z"), (Object)bucket1.getCreationDate());
        Bucket bucket2 = buckets.get(1);
        Assert.assertEquals((Object)"51744", (Object)bucket2.getOwner().getId());
        Assert.assertEquals((Object)"51744", (Object)bucket2.getOwner().getDisplayName());
        Assert.assertEquals((Object)"ganshumantest", (Object)bucket2.getName());
        Assert.assertEquals((Object)DateUtil.parseIso8601Date("2012-02-09T06:38:47.000Z"), (Object)bucket2.getCreationDate());
        in.close();
        filename = "listBucketTruncated.xml";
        in = this.getInputStream(filename);
        bucketList = ResponseParsers.parseListBucket(in);
        Assert.assertEquals((Object)"asdasdasdasd", (Object)bucketList.getPrefix());
        Assert.assertEquals((Object)"asdasdasd", (Object)bucketList.getMarker());
        Assert.assertEquals((Object)1, (Object)bucketList.getMaxKeys());
        Assert.assertEquals((Object)true, (Object)bucketList.isTruncated());
        Assert.assertEquals((Object)"asdasdasdasdasd", (Object)bucketList.getNextMarker());
        buckets = bucketList.getBucketList();
        bucket1 = buckets.get(0);
        Assert.assertEquals((Object)"51744", (Object)bucket1.getOwner().getId());
        Assert.assertEquals((Object)"51744", (Object)bucket1.getOwner().getDisplayName());
        Assert.assertEquals((Object)"asdasdasdasd", (Object)bucket1.getName());
        Assert.assertEquals((Object)"osslocation", (Object)bucket1.getLocation());
        Assert.assertEquals((Object)DateUtil.parseIso8601Date("2014-05-15T11:18:32.000Z"), (Object)bucket1.getCreationDate());
        in.close();
    }

    @Test
    public void testCopyObjectResult() throws Exception {
        String filename = "copyObject.xml";
        InputStream in = this.getInputStream(filename);
        CopyObjectResult result = ResponseParsers.parseCopyObjectResult(in);
        Assert.assertEquals((Object)"4F62D1D6EF439E057D4BD20F43DC2C84", (Object)result.getETag());
        Assert.assertEquals((Object)"Wed, 27 Jun 2012 07:28:49 GMT", (Object)DateUtil.formatRfc822Date(result.getLastModified()));
    }

    @Test
    public void testParseInitiateMultipartUpload() throws Exception {
        String filename = "initiateMultipartUpload.xml";
        InputStream in = this.getInputStream(filename);
        InitiateMultipartUploadResult initiateMultipartUploadResult = ResponseParsers.parseInitiateMultipartUpload(in);
        Assert.assertEquals((Object)"dp7d8j2xfec1m984em9xmkgc_gan", (Object)initiateMultipartUploadResult.getBucketName());
        Assert.assertEquals((Object)"test.rar", (Object)initiateMultipartUploadResult.getKey());
        Assert.assertEquals((Object)"0004B9847F209E446A8BA24F84C6881D", (Object)initiateMultipartUploadResult.getUploadId());
        in.close();
    }

    @Test
    public void testParseListMultipartUploads() throws Exception {
        String filename = "listMultipartUploads.xml";
        InputStream in = this.getInputStream(filename);
        MultipartUploadListing multipartUploadListing = ResponseParsers.parseListMultipartUploads(in);
        Assert.assertEquals((Object)"dp7d8j2xfec1m984em9xmkgc_gan", (Object)multipartUploadListing.getBucketName());
        Assert.assertNull((Object)multipartUploadListing.getKeyMarker());
        Assert.assertNull((Object)multipartUploadListing.getUploadIdMarker());
        Assert.assertEquals((Object)"test.rar", (Object)multipartUploadListing.getNextKeyMarker());
        Assert.assertEquals((Object)"0004B984CE74CF65B555A38F98CCFF96", (Object)multipartUploadListing.getNextUploadIdMarker());
        Assert.assertNull((Object)multipartUploadListing.getDelimiter());
        Assert.assertNull((Object)multipartUploadListing.getPrefix());
        Assert.assertEquals((long)1000L, (long)multipartUploadListing.getMaxUploads());
        Assert.assertEquals((Object)false, (Object)multipartUploadListing.isTruncated());
        Assert.assertEquals((Object)"test.rar", (Object)multipartUploadListing.getMultipartUploads().get(0).getKey());
        Assert.assertEquals((Object)"0004B9846579745A77D988FFFDDEAFC3", (Object)multipartUploadListing.getMultipartUploads().get(0).getUploadId());
        Assert.assertEquals((Object)"Standard", (Object)multipartUploadListing.getMultipartUploads().get(0).getStorageClass());
        Assert.assertEquals((Object)DateUtil.parseIso8601Date("2012-02-22T02:36:36.000Z"), (Object)multipartUploadListing.getMultipartUploads().get(0).getInitiated());
        in.close();
    }

    @Test
    public void testParseListParts() throws Exception {
        String filename = "listParts.xml";
        InputStream in = this.getInputStream(filename);
        PartListing partListing = ResponseParsers.parseListParts(in);
        Assert.assertEquals((Object)"dp7d8j2xfec1m984em9xmkgc_gan", (Object)partListing.getBucketName());
        Assert.assertEquals((Object)"test.rar", (Object)partListing.getKey());
        Assert.assertEquals((Object)"0004B98692BB2A28C897B642CFAC1DCE", (Object)partListing.getUploadId());
        Assert.assertEquals((Object)"Standard", (Object)partListing.getStorageClass());
        Assert.assertEquals((long)3L, (long)partListing.getNextPartNumberMarker().intValue());
        Assert.assertEquals((long)1000L, (long)partListing.getMaxParts().intValue());
        Assert.assertEquals((Object)false, (Object)partListing.isTruncated());
        List<PartSummary> parts = partListing.getParts();
        Assert.assertNotNull(parts);
        Assert.assertTrue((parts.size() == 1 ? 1 : 0) != 0);
        PartSummary part = parts.get(0);
        Assert.assertEquals((long)3L, (long)part.getPartNumber());
        Assert.assertEquals((Object)DateUtil.parseIso8601Date("2012-02-22T05:12:29.000Z"), (Object)part.getLastModified());
        Assert.assertEquals((Object)"4B4BEAF5BC622FC89D29BF0E3B70B730", (Object)part.getETag());
        Assert.assertEquals((long)3996796L, (long)part.getSize());
        in.close();
    }

    @Test
    public void testParseCompleteMultipartUpload() throws Exception {
        String filename = "completeMultipartUpload.xml";
        InputStream in = this.getInputStream(filename);
        CompleteMultipartUploadResult completeMultipartUploadResult = ResponseParsers.parseCompleteMultipartUpload(in);
        Assert.assertEquals((Object)"http://oss-test.aliyun-inc.com/dp7d8j2xfec1m984em9xmkgc_gan/test.rar", (Object)completeMultipartUploadResult.getLocation());
        Assert.assertEquals((Object)"dp7d8j2xfec1m984em9xmkgc_gan", (Object)completeMultipartUploadResult.getBucketName());
        Assert.assertEquals((Object)"test.rar", (Object)completeMultipartUploadResult.getKey());
        Assert.assertEquals((Object)"894061A784C63D244E6E18B80E36076A-1", (Object)completeMultipartUploadResult.getETag());
        in.close();
    }
}

