/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.ListBucketsRequest;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class ListBucketsTest
extends TestBase {
    private static final int MAX_BUCKETS_ALLOWED = 10;

    @Test
    public void testNormalListBuckets() {
        String bucketNamePrefix = "normal-list-buckets-";
        try {
            ArrayList<String> existingBuckets = new ArrayList<String>();
            List<Bucket> returnedBuckets = secondClient.listBuckets();
            for (Bucket bkt : returnedBuckets) {
                existingBuckets.add(bkt.getName());
            }
            int remaindingAllowed = 10 - existingBuckets.size();
            ArrayList<Object> newlyBuckets = new ArrayList<Object>();
            int i = 0;
            while (i < remaindingAllowed) {
                String bucketName = "normal-list-buckets-" + i;
                try {
                    secondClient.createBucket(bucketName);
                    newlyBuckets.add(bucketName);
                    TestUtils.waitForCacheExpiration(5);
                    String string = secondClient.getBucketLocation(bucketName);
                    Assert.assertEquals((String)"oss-cn-hangzhou", (String)string);
                }
                catch (Exception exception) {
                    Assert.fail((String)exception.getMessage());
                }
                ++i;
            }
            TestUtils.waitForCacheExpiration(5);
            returnedBuckets = secondClient.listBuckets();
            existingBuckets.clear();
            for (Bucket bkt : returnedBuckets) {
                existingBuckets.add(bkt.getName());
            }
            Assert.assertEquals((int)10, (int)existingBuckets.size());
            BucketList bucketList = secondClient.listBuckets("normal-list-buckets-", null, null);
            Assert.assertEquals((int)remaindingAllowed, (int)bucketList.getBucketList().size());
            for (Bucket bkt : bucketList.getBucketList()) {
                Assert.assertTrue((boolean)bkt.getName().startsWith("normal-list-buckets-"));
            }
            int maxKeys = 3;
            bucketList = secondClient.listBuckets("normal-list-buckets-", null, 3);
            Assert.assertTrue((bucketList.getBucketList().size() <= 3 ? 1 : 0) != 0);
            returnedBuckets.clear();
            returnedBuckets.addAll(bucketList.getBucketList());
            while (bucketList.isTruncated()) {
                Assert.assertTrue(((bucketList = secondClient.listBuckets(new ListBucketsRequest("normal-list-buckets-", bucketList.getNextMarker(), 3))).getBucketList().size() <= 3 ? 1 : 0) != 0);
                returnedBuckets.addAll(bucketList.getBucketList());
            }
            Assert.assertEquals((int)remaindingAllowed, (int)returnedBuckets.size());
            for (Bucket bucket : returnedBuckets) {
                Assert.assertTrue((boolean)bucket.getName().startsWith("normal-list-buckets-"));
            }
            for (String string : newlyBuckets) {
                secondClient.deleteBucket(string);
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnormalListBuckets() {
        String nonexistentBucketNamePrefix = "nonexistent-bucket-name-prefix-";
        try {
            BucketList bucketList = secondClient.listBuckets("nonexistent-bucket-name-prefix-", null, null);
            Assert.assertEquals((int)0, (int)bucketList.getBucketList().size());
            bucketList = secondClient.listBuckets(null, null, 0);
            Assert.fail((String)"List bucket should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"InvalidArgument", (String)e.getErrorCode());
        }
    }
}

