/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.testing;

import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Ignore;

public class UrlSignatureTest {
    static final String endpoint = "<valid endpoint>";
    static final String accessId = "<your access id>";
    static final String accessKey = "<your access key>";
    static OSSClient client = new OSSClient("<valid endpoint>", "<your access id>", "<your access key>");
    static final String bucketName = "<your bucket name>";
    static final String key = "<object key>";
    static final String filePath = "<file to upload>";

    @Ignore
    public void testGetObject() {
        try {
            String expectedETag;
            block8: {
                Date expiration = DateUtil.parseRfc822Date("Thu, 19 Mar 2015 18:00:00 GMT");
                GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key, HttpMethod.GET);
                request.setExpiration(expiration);
                request.setContentType("application/octet-stream");
                URL signedUrl = client.generatePresignedUrl(request);
                System.out.println("signed url for getObject: " + signedUrl);
                HashMap<String, String> customHeaders = new HashMap<String, String>();
                customHeaders.put("Range", "bytes=100-1000");
                customHeaders.put("Content-Type", "application/octet-stream");
                OSSObject object = client.getObject(signedUrl, customHeaders);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                expectedETag = null;
                try {
                    try {
                        int bytesRead;
                        int bufSize = 4096;
                        byte[] buffer = new byte[bufSize];
                        while ((bytesRead = object.getObjectContent().read(buffer)) != -1) {
                            outputStream.write(buffer, 0, bytesRead);
                        }
                        expectedETag = BinaryUtil.encodeMD5(outputStream.toByteArray());
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                        IOUtils.safeClose(outputStream);
                        IOUtils.safeClose(object.getObjectContent());
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.safeClose(outputStream);
                    IOUtils.safeClose(object.getObjectContent());
                    throw throwable;
                }
                IOUtils.safeClose(outputStream);
                IOUtils.safeClose(object.getObjectContent());
            }
            ObjectMetadata metadata = client.getObjectMetadata(bucketName, key);
            String actualETag = metadata.getETag();
            Assert.assertEquals((String)expectedETag, (String)actualETag);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Ignore
    public void testPutObject() {
        OSSClient client = new OSSClient(endpoint, accessId, accessKey);
        try {
            Date expiration = DateUtil.parseRfc822Date("Thu, 19 Mar 2015 18:00:00 GMT");
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key, HttpMethod.PUT);
            request.setExpiration(expiration);
            request.setContentType("application/octet-stream");
            request.addUserMetadata("author", "aliy");
            URL signedUrl = client.generatePresignedUrl(request);
            System.out.println("signed url for putObject: " + signedUrl);
            File f = new File(filePath);
            FileInputStream fin = new FileInputStream(f);
            HashMap<String, String> customHeaders = new HashMap<String, String>();
            customHeaders.put("Content-Type", "application/octet-stream");
            customHeaders.put("x-oss-meta-author", "aliy");
            PutObjectResult result = client.putObject(signedUrl, fin, f.length(), customHeaders);
            fin = new FileInputStream(f);
            byte[] binaryData = IOUtils.readStreamAsByteArray(fin);
            String expectedETag = BinaryUtil.encodeMD5(binaryData);
            String actualETag = result.getETag();
            Assert.assertEquals((String)expectedETag, (String)actualETag);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

