/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.internal.OSSObjectOperation;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.DownloadFileResult;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.SimplifiedObjectMeta;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class OSSDownloadOperation {
    private OSSObjectOperation objectOperation;

    public OSSDownloadOperation(OSSObjectOperation objectOperation) {
        this.objectOperation = objectOperation;
    }

    public DownloadFileResult downloadFile(DownloadFileRequest downloadFileRequest) throws Throwable {
        CodingUtils.assertParameterNotNull(downloadFileRequest, "downloadFileRequest");
        String bucketName = downloadFileRequest.getBucketName();
        String key = downloadFileRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        if (downloadFileRequest.getDownloadFile() == null) {
            downloadFileRequest.setDownloadFile(downloadFileRequest.getKey());
        }
        if (downloadFileRequest.isEnableCheckpoint() && (downloadFileRequest.getCheckpointFile() == null || downloadFileRequest.getCheckpointFile().isEmpty())) {
            downloadFileRequest.setCheckpointFile(downloadFileRequest.getDownloadFile() + ".dcp");
        }
        return this.downloadFileWithCheckpoint(downloadFileRequest);
    }

    private DownloadFileResult downloadFileWithCheckpoint(DownloadFileRequest downloadFileRequest) throws Throwable {
        DownloadFileResult downloadFileResult = new DownloadFileResult();
        DownloadCheckPoint downloadCheckPoint = new DownloadCheckPoint();
        if (downloadFileRequest.isEnableCheckpoint()) {
            try {
                downloadCheckPoint.load(downloadFileRequest.getCheckpointFile());
            }
            catch (Exception e) {
                this.remove(downloadFileRequest.getCheckpointFile());
            }
            if (!downloadCheckPoint.isValid(this.objectOperation)) {
                this.prepare(downloadCheckPoint, downloadFileRequest);
                this.remove(downloadFileRequest.getCheckpointFile());
            }
        } else {
            this.prepare(downloadCheckPoint, downloadFileRequest);
        }
        DownloadResult downloadResult = this.download(downloadCheckPoint, downloadFileRequest);
        for (PartResult partResult : downloadResult.getPartResults()) {
            if (!partResult.isFailed()) continue;
            throw partResult.getException();
        }
        if (downloadFileRequest.isEnableCheckpoint()) {
            this.remove(downloadFileRequest.getCheckpointFile());
        }
        downloadFileResult.setObjectMetadata(downloadResult.getObjectMetadata());
        return downloadFileResult;
    }

    private void prepare(DownloadCheckPoint downloadCheckPoint, DownloadFileRequest downloadFileRequest) throws IOException {
        downloadCheckPoint.magic = "92611BED-89E2-46B6-89E5-72F273D4B0A3";
        downloadCheckPoint.downloadFile = downloadFileRequest.getDownloadFile();
        downloadCheckPoint.bucketName = downloadFileRequest.getBucketName();
        downloadCheckPoint.objectKey = downloadFileRequest.getKey();
        downloadCheckPoint.objectStat = ObjectStat.getFileStat(this.objectOperation, downloadCheckPoint.bucketName, downloadCheckPoint.objectKey);
        downloadCheckPoint.downloadParts = this.splitFile(downloadCheckPoint.objectStat.size, downloadFileRequest.getPartSize());
        OSSDownloadOperation.createFixedFile(downloadFileRequest.getDownloadFile(), downloadCheckPoint.objectStat.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFixedFile(String filePath, long length) throws IOException {
        File file = new File(filePath);
        RandomAccessFile rf = null;
        try {
            rf = new RandomAccessFile(file, "rw");
            rf.setLength(length);
        }
        finally {
            if (rf != null) {
                rf.close();
            }
        }
    }

    private DownloadResult download(DownloadCheckPoint downloadCheckPoint, DownloadFileRequest downloadFileRequest) throws Throwable {
        DownloadResult downloadResult = new DownloadResult();
        ArrayList<PartResult> taskResults = new ArrayList<PartResult>();
        ExecutorService service = Executors.newFixedThreadPool(downloadFileRequest.getTaskNum());
        ArrayList<Future<PartResult>> futures = new ArrayList<Future<PartResult>>();
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (int i = 0; i < downloadCheckPoint.downloadParts.size(); ++i) {
            if (!downloadCheckPoint.downloadParts.get((int)i).isCompleted) {
                Task task = new Task(i, "download-" + i, downloadCheckPoint, i, downloadFileRequest, this.objectOperation);
                futures.add(service.submit(task));
                tasks.add(task);
                continue;
            }
            taskResults.add(new PartResult(i + 1, downloadCheckPoint.downloadParts.get((int)i).start, downloadCheckPoint.downloadParts.get((int)i).end));
        }
        service.shutdown();
        service.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        for (Future future : futures) {
            try {
                PartResult tr = (PartResult)future.get();
                taskResults.add(tr);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
        Collections.sort(taskResults, new Comparator<PartResult>(){

            @Override
            public int compare(PartResult p1, PartResult p2) {
                return p1.getNumber() - p2.getNumber();
            }
        });
        downloadResult.setPartResults(taskResults);
        if (tasks.size() > 0) {
            downloadResult.setObjectMetadata(((Task)tasks.get(0)).GetobjectMetadata());
        }
        return downloadResult;
    }

    private ArrayList<DownloadPart> splitFile(long objectSize, long partSize) {
        ArrayList<DownloadPart> parts = new ArrayList<DownloadPart>();
        long partNum = objectSize / partSize;
        if (partNum >= 10000L) {
            partSize = objectSize / 9999L;
        }
        int i = 0;
        for (long offset = 0L; offset < objectSize; offset += partSize) {
            DownloadPart part = new DownloadPart();
            part.index = i++;
            part.start = offset;
            part.end = this.getPartEnd(offset, objectSize, partSize);
            parts.add(part);
        }
        return parts;
    }

    private long getPartEnd(long begin, long total, long per) {
        if (begin + per > total) {
            return total - 1L;
        }
        return begin + per - 1L;
    }

    private boolean remove(String filePath) {
        boolean flag = false;
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    static class Task
    implements Callable<PartResult> {
        private int id;
        private String name;
        private DownloadCheckPoint downloadCheckPoint;
        private int partIndex;
        private DownloadFileRequest downloadFileRequest;
        private OSSObjectOperation objectOperation;
        private ObjectMetadata objectMetadata;

        public Task(int id, String name, DownloadCheckPoint downloadCheckPoint, int partIndex, DownloadFileRequest downloadFileRequest, OSSObjectOperation objectOperation) {
            this.id = id;
            this.name = name;
            this.downloadCheckPoint = downloadCheckPoint;
            this.partIndex = partIndex;
            this.downloadFileRequest = downloadFileRequest;
            this.objectOperation = objectOperation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartResult call() throws Exception {
            PartResult tr = null;
            RandomAccessFile output = null;
            InputStream content = null;
            try {
                DownloadPart downloadPart = this.downloadCheckPoint.downloadParts.get(this.partIndex);
                tr = new PartResult(this.partIndex + 1, downloadPart.start, downloadPart.end);
                output = new RandomAccessFile(this.downloadFileRequest.getDownloadFile(), "rw");
                output.seek(downloadPart.start);
                GetObjectRequest getObjectRequest = new GetObjectRequest(this.downloadFileRequest.getBucketName(), this.downloadFileRequest.getKey());
                getObjectRequest.setMatchingETagConstraints(this.downloadFileRequest.getMatchingETagConstraints());
                getObjectRequest.setNonmatchingETagConstraints(this.downloadFileRequest.getNonmatchingETagConstraints());
                getObjectRequest.setModifiedSinceConstraint(this.downloadFileRequest.getModifiedSinceConstraint());
                getObjectRequest.setUnmodifiedSinceConstraint(this.downloadFileRequest.getUnmodifiedSinceConstraint());
                getObjectRequest.setResponseHeaders(this.downloadFileRequest.getResponseHeaders());
                getObjectRequest.setRange(downloadPart.start, downloadPart.end);
                OSSObject ossObj = this.objectOperation.getObject(getObjectRequest);
                this.objectMetadata = ossObj.getObjectMetadata();
                content = ossObj.getObjectContent();
                byte[] buffer = new byte[8192];
                int bytesRead = 0;
                while ((bytesRead = content.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                this.downloadCheckPoint.update(this.partIndex, true);
                if (this.downloadFileRequest.isEnableCheckpoint()) {
                    this.downloadCheckPoint.dump(this.downloadFileRequest.getCheckpointFile());
                }
            }
            catch (Exception e) {
                tr.setFailed(true);
                tr.setException(e);
                LogUtils.logException(String.format("Task %d:%s upload part %d failed: ", this.id, this.name, this.partIndex), e);
            }
            finally {
                if (output != null) {
                    output.close();
                }
                if (content != null) {
                    content.close();
                }
            }
            return tr;
        }

        public ObjectMetadata GetobjectMetadata() {
            return this.objectMetadata;
        }
    }

    static class DownloadResult {
        private List<PartResult> partResults;
        private ObjectMetadata objectMetadata;

        DownloadResult() {
        }

        public List<PartResult> getPartResults() {
            return this.partResults;
        }

        public void setPartResults(List<PartResult> partResults) {
            this.partResults = partResults;
        }

        public ObjectMetadata getObjectMetadata() {
            return this.objectMetadata;
        }

        public void setObjectMetadata(ObjectMetadata objectMetadata) {
            this.objectMetadata = objectMetadata;
        }
    }

    static class PartResult {
        private int number;
        private long start;
        private long end;
        private boolean failed;
        private Exception exception;

        public PartResult(int number, long start, long end) {
            this.number = number;
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public long getEnd() {
            return this.end;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public int getNumber() {
            return this.number;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void setFailed(boolean failed) {
            this.failed = failed;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }

    static class DownloadPart
    implements Serializable {
        private static final long serialVersionUID = -3655925846487976207L;
        public int index;
        public long start;
        public long end;
        public boolean isCompleted;

        DownloadPart() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + (this.isCompleted ? 1231 : 1237);
            result = 31 * result + (int)(this.end ^ this.end >>> 32);
            result = 31 * result + (int)(this.start ^ this.start >>> 32);
            return result;
        }
    }

    static class ObjectStat
    implements Serializable {
        private static final long serialVersionUID = -2883494783412999919L;
        public long size;
        public Date lastModified;
        public String digest;

        ObjectStat() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.digest == null ? 0 : this.digest.hashCode());
            result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public static ObjectStat getFileStat(OSSObjectOperation objectOperation, String bucketName, String key) {
            GenericRequest genericRequest = new GenericRequest(bucketName, key);
            SimplifiedObjectMeta meta = objectOperation.getSimplifiedObjectMeta(genericRequest);
            ObjectStat objStat = new ObjectStat();
            objStat.size = meta.getSize();
            objStat.lastModified = meta.getLastModified();
            objStat.digest = meta.getETag();
            return objStat;
        }
    }

    static class DownloadCheckPoint
    implements Serializable {
        private static final long serialVersionUID = 4682293344365787077L;
        private static final String DOWNLOAD_MAGIC = "92611BED-89E2-46B6-89E5-72F273D4B0A3";
        public String magic;
        public int md5;
        public String downloadFile;
        public String bucketName;
        public String objectKey;
        public ObjectStat objectStat;
        public ArrayList<DownloadPart> downloadParts;

        DownloadCheckPoint() {
        }

        public synchronized void load(String cpFile) throws IOException, ClassNotFoundException {
            FileInputStream fileIn = new FileInputStream(cpFile);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            DownloadCheckPoint dcp = (DownloadCheckPoint)in.readObject();
            this.assign(dcp);
            in.close();
            fileIn.close();
        }

        public synchronized void dump(String cpFile) throws IOException {
            this.md5 = this.hashCode();
            FileOutputStream fileOut = new FileOutputStream(cpFile);
            ObjectOutputStream outStream = new ObjectOutputStream(fileOut);
            outStream.writeObject(this);
            outStream.close();
            fileOut.close();
        }

        public synchronized void update(int index, boolean completed) throws IOException {
            this.downloadParts.get((int)index).isCompleted = completed;
        }

        public synchronized boolean isValid(OSSObjectOperation objectOperation) {
            if (this.magic == null || !this.magic.equals(DOWNLOAD_MAGIC) || this.md5 != this.hashCode()) {
                return false;
            }
            GenericRequest genericRequest = new GenericRequest(this.bucketName, this.objectKey);
            SimplifiedObjectMeta meta = objectOperation.getSimplifiedObjectMeta(genericRequest);
            return this.objectStat.size == meta.getSize() && this.objectStat.lastModified.equals(meta.getLastModified()) && this.objectStat.digest.equals(meta.getETag());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
            result = 31 * result + (this.downloadFile == null ? 0 : this.downloadFile.hashCode());
            result = 31 * result + (this.magic == null ? 0 : this.magic.hashCode());
            result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
            result = 31 * result + (this.objectStat == null ? 0 : this.objectStat.hashCode());
            result = 31 * result + (this.downloadParts == null ? 0 : this.downloadParts.hashCode());
            return result;
        }

        private void assign(DownloadCheckPoint dcp) {
            this.magic = dcp.magic;
            this.md5 = dcp.md5;
            this.downloadFile = dcp.downloadFile;
            this.bucketName = dcp.bucketName;
            this.objectKey = dcp.objectKey;
            this.objectStat = dcp.objectStat;
            this.downloadParts = dcp.downloadParts;
        }
    }
}

