/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.DefaultServiceClient;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.LogUtils;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

public class TimeoutServiceClient
extends DefaultServiceClient {
    protected ThreadPoolExecutor executor;

    public TimeoutServiceClient(ClientConfiguration config) {
        super(config);
        int processors = Runtime.getRuntime().availableProcessors();
        this.executor = new ThreadPoolExecutor(processors * 5, processors * 10, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(processors * 100), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.executor.allowCoreThreadTimeOut(true);
    }

    @Override
    public ResponseMessage sendRequestCore(ServiceClient.Request request, ExecutionContext context) throws IOException {
        HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request, context);
        HttpClientContext httpContext = HttpClientContext.create();
        httpContext.setRequestConfig(this.requestConfig);
        CloseableHttpResponse httpResponse = null;
        HttpRequestTask httpRequestTask = new HttpRequestTask(httpRequest, httpContext);
        Future<CloseableHttpResponse> future = this.executor.submit(httpRequestTask);
        try {
            httpResponse = future.get(this.config.getRequestTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LogUtils.logException("[ExecutorService]The current thread was interrupted while waiting: ", e);
            httpRequest.abort();
            throw new ClientException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            httpRequest.abort();
            RuntimeException ex = e.getCause() instanceof IOException ? ExceptionFactory.createNetworkException((IOException)e.getCause()) : new OSSException(e.getMessage(), e);
            LogUtils.logException("[ExecutorService]The computation threw an exception: ", ex);
            throw ex;
        }
        catch (TimeoutException e) {
            LogUtils.logException("[ExecutorService]The wait " + this.config.getRequestTimeout() + " timed out: ", e);
            httpRequest.abort();
            throw new ClientException(e.getMessage(), "RequestTimeout", "Unknown", e);
        }
        return TimeoutServiceClient.buildResponse(request, httpResponse);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(60000L, TimeUnit.MILLISECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(60000L, TimeUnit.MILLISECONDS)) {
                    LogUtils.getLog().warn((Object)"Pool did not terminate in 60 seconds");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        super.shutdown();
    }

    class HttpRequestTask
    implements Callable<CloseableHttpResponse> {
        private HttpRequestBase httpRequest;
        private HttpClientContext httpContext;

        public HttpRequestTask(HttpRequestBase httpRequest, HttpClientContext httpContext) {
            this.httpRequest = httpRequest;
            this.httpContext = httpContext;
        }

        @Override
        public CloseableHttpResponse call() throws Exception {
            return TimeoutServiceClient.this.httpClient.execute((HttpUriRequest)this.httpRequest, (HttpContext)this.httpContext);
        }
    }
}

