/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.InconsistentException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.CRC64;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.event.ProgressPublisher;
import com.aliyun.oss.internal.Mimetypes;
import com.aliyun.oss.internal.OSSMultipartOperation;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.Payer;
import com.aliyun.oss.model.UploadFileRequest;
import com.aliyun.oss.model.UploadFileResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class OSSUploadOperation {
    protected OSSMultipartOperation multipartOperation;

    protected UploadCheckPoint createUploadCheckPointWrap() {
        return new UploadCheckPoint();
    }

    protected void loadUploadCheckPointWrap(UploadCheckPoint uploadCheckPoint, String checkpointFile) throws Throwable {
        uploadCheckPoint.load(checkpointFile);
    }

    protected InitiateMultipartUploadResult initiateMultipartUploadWrap(UploadCheckPoint uploadCheckPoint, InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws OSSException, ClientException {
        return this.multipartOperation.initiateMultipartUpload(initiateMultipartUploadRequest);
    }

    protected UploadPartResult uploadPartWrap(UploadCheckPoint uploadCheckPoint, UploadPartRequest request) throws OSSException, ClientException {
        return this.multipartOperation.uploadPart(request);
    }

    protected CompleteMultipartUploadResult completeMultipartUploadWrap(UploadCheckPoint uploadCheckPoint, CompleteMultipartUploadRequest request) throws OSSException, ClientException {
        return this.multipartOperation.completeMultipartUpload(request);
    }

    public OSSUploadOperation(OSSMultipartOperation multipartOperation) {
        this.multipartOperation = multipartOperation;
    }

    public UploadFileResult uploadFile(UploadFileRequest uploadFileRequest) throws Throwable {
        CodingUtils.assertParameterNotNull(uploadFileRequest, "uploadFileRequest");
        String bucketName = uploadFileRequest.getBucketName();
        String key = uploadFileRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertParameterNotNull(uploadFileRequest.getUploadFile(), "uploadFile");
        CodingUtils.assertFileExist(uploadFileRequest.getUploadFile(), "uploadFile");
        if (uploadFileRequest.isEnableCheckpoint() && (uploadFileRequest.getCheckpointFile() == null || uploadFileRequest.getCheckpointFile().isEmpty())) {
            uploadFileRequest.setCheckpointFile(uploadFileRequest.getUploadFile() + ".ucp");
        }
        return this.uploadFileWithCheckpoint(uploadFileRequest);
    }

    private UploadFileResult uploadFileWithCheckpoint(UploadFileRequest uploadFileRequest) throws Throwable {
        UploadFileResult uploadFileResult = new UploadFileResult();
        UploadCheckPoint uploadCheckPoint = this.createUploadCheckPointWrap();
        if (uploadFileRequest.isEnableCheckpoint()) {
            try {
                this.loadUploadCheckPointWrap(uploadCheckPoint, uploadFileRequest.getCheckpointFile());
            }
            catch (Exception e) {
                this.remove(uploadFileRequest.getCheckpointFile());
            }
            if (!uploadCheckPoint.isValid(uploadFileRequest.getUploadFile())) {
                this.prepare(uploadCheckPoint, uploadFileRequest);
                this.remove(uploadFileRequest.getCheckpointFile());
            }
        } else {
            this.prepare(uploadCheckPoint, uploadFileRequest);
        }
        ProgressListener listener = uploadFileRequest.getProgressListener();
        ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_STARTED_EVENT);
        ArrayList<PartResult> partResults = this.upload(uploadCheckPoint, uploadFileRequest);
        for (PartResult partResult : partResults) {
            if (!partResult.isFailed()) continue;
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_PART_FAILED_EVENT);
            throw partResult.getException();
        }
        ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        CompleteMultipartUploadResult multipartUploadResult = this.complete(uploadCheckPoint, uploadFileRequest);
        uploadFileResult.setMultipartUploadResult(multipartUploadResult);
        if (this.multipartOperation.getInnerClient().getClientConfiguration().isCrcCheckEnabled()) {
            Long clientCRC = OSSUploadOperation.calcObjectCRCFromParts(partResults);
            multipartUploadResult.setClientCRC(clientCRC);
            try {
                OSSUtils.checkChecksum(clientCRC, multipartUploadResult.getServerCRC(), multipartUploadResult.getRequestId());
            }
            catch (Exception e) {
                ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
                throw new InconsistentException(clientCRC, multipartUploadResult.getServerCRC(), multipartUploadResult.getRequestId());
            }
        }
        if (uploadFileRequest.isEnableCheckpoint()) {
            this.remove(uploadFileRequest.getCheckpointFile());
        }
        return uploadFileResult;
    }

    private static Long calcObjectCRCFromParts(List<PartResult> partResults) {
        long crc = 0L;
        for (PartResult partResult : partResults) {
            if (partResult.getPartCRC() == null || partResult.getLength() <= 0L) {
                return null;
            }
            crc = CRC64.combine(crc, partResult.getPartCRC(), partResult.getLength());
        }
        return new Long(crc);
    }

    private void prepare(UploadCheckPoint uploadCheckPoint, UploadFileRequest uploadFileRequest) {
        uploadCheckPoint.magic = "FE8BB4EA-B593-4FAC-AD7A-2459A36E2E62";
        uploadCheckPoint.uploadFile = uploadFileRequest.getUploadFile();
        uploadCheckPoint.key = uploadFileRequest.getKey();
        uploadCheckPoint.uploadFileStat = FileStat.getFileStat(uploadCheckPoint.uploadFile);
        uploadCheckPoint.uploadParts = this.splitFile(uploadCheckPoint.uploadFileStat.size, uploadFileRequest.getPartSize());
        uploadCheckPoint.partETags = new ArrayList();
        uploadCheckPoint.originPartSize = uploadFileRequest.getPartSize();
        ObjectMetadata metadata = uploadFileRequest.getObjectMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (metadata.getContentType() == null) {
            metadata.setContentType(Mimetypes.getInstance().getMimetype(uploadCheckPoint.uploadFile, uploadCheckPoint.key));
        }
        InitiateMultipartUploadRequest initiateUploadRequest = new InitiateMultipartUploadRequest(uploadFileRequest.getBucketName(), uploadFileRequest.getKey(), metadata);
        Payer payer = uploadFileRequest.getRequestPayer();
        if (payer != null) {
            initiateUploadRequest.setRequestPayer(payer);
        }
        initiateUploadRequest.setSequentialMode(uploadFileRequest.getSequentialMode());
        InitiateMultipartUploadResult initiateUploadResult = this.initiateMultipartUploadWrap(uploadCheckPoint, initiateUploadRequest);
        uploadCheckPoint.uploadID = initiateUploadResult.getUploadId();
    }

    private ArrayList<PartResult> upload(UploadCheckPoint uploadCheckPoint, UploadFileRequest uploadFileRequest) throws Throwable {
        int i;
        ArrayList<PartResult> taskResults = new ArrayList<PartResult>();
        ExecutorService service = Executors.newFixedThreadPool(uploadFileRequest.getTaskNum());
        ArrayList<Future<PartResult>> futures = new ArrayList<Future<PartResult>>();
        ProgressListener listener = uploadFileRequest.getProgressListener();
        long contentLength = 0L;
        long completedLength = 0L;
        for (i = 0; i < uploadCheckPoint.uploadParts.size(); ++i) {
            long l = uploadCheckPoint.uploadParts.get((int)i).size;
            contentLength += l;
            if (!uploadCheckPoint.uploadParts.get((int)i).isCompleted) continue;
            completedLength += l;
        }
        ProgressPublisher.publishRequestContentLength(listener, contentLength);
        ProgressPublisher.publishRequestBytesTransferred(listener, completedLength);
        uploadFileRequest.setProgressListener(null);
        for (i = 0; i < uploadCheckPoint.uploadParts.size(); ++i) {
            if (!uploadCheckPoint.uploadParts.get((int)i).isCompleted) {
                futures.add(service.submit(new Task(i, "upload-" + i, uploadCheckPoint, i, uploadFileRequest, this.multipartOperation, listener)));
                continue;
            }
            taskResults.add(new PartResult(i + 1, uploadCheckPoint.uploadParts.get((int)i).offset, uploadCheckPoint.uploadParts.get((int)i).size, uploadCheckPoint.uploadParts.get((int)i).crc));
        }
        service.shutdown();
        service.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        for (Future future : futures) {
            try {
                PartResult tr = (PartResult)future.get();
                taskResults.add(tr);
            }
            catch (ExecutionException e) {
                uploadFileRequest.setProgressListener(listener);
                throw e.getCause();
            }
        }
        Collections.sort(taskResults, new Comparator<PartResult>(){

            @Override
            public int compare(PartResult p1, PartResult p2) {
                return p1.getNumber() - p2.getNumber();
            }
        });
        uploadFileRequest.setProgressListener(listener);
        return taskResults;
    }

    private CompleteMultipartUploadResult complete(UploadCheckPoint uploadCheckPoint, UploadFileRequest uploadFileRequest) {
        String acl;
        ObjectMetadata metadata;
        Collections.sort(uploadCheckPoint.partETags, new Comparator<PartETag>(){

            @Override
            public int compare(PartETag p1, PartETag p2) {
                return p1.getPartNumber() - p2.getPartNumber();
            }
        });
        CompleteMultipartUploadRequest completeUploadRequest = new CompleteMultipartUploadRequest(uploadFileRequest.getBucketName(), uploadFileRequest.getKey(), uploadCheckPoint.uploadID, uploadCheckPoint.partETags);
        Payer payer = uploadFileRequest.getRequestPayer();
        if (payer != null) {
            completeUploadRequest.setRequestPayer(payer);
        }
        if ((metadata = uploadFileRequest.getObjectMetadata()) != null && (acl = (String)metadata.getRawMetadata().get("x-oss-object-acl")) != null && !acl.equals("")) {
            CannedAccessControlList accessControlList = CannedAccessControlList.parse(acl);
            completeUploadRequest.setObjectACL(accessControlList);
        }
        completeUploadRequest.setCallback(uploadFileRequest.getCallback());
        return this.completeMultipartUploadWrap(uploadCheckPoint, completeUploadRequest);
    }

    private ArrayList<UploadPart> splitFile(long fileSize, long partSize) {
        ArrayList<UploadPart> parts = new ArrayList<UploadPart>();
        long partNum = fileSize / partSize;
        if (partNum >= 10000L) {
            partSize = fileSize / 9999L;
            partNum = fileSize / partSize;
        }
        for (long i = 0L; i < partNum; ++i) {
            UploadPart part = new UploadPart();
            part.number = (int)(i + 1L);
            part.offset = i * partSize;
            part.size = partSize;
            part.isCompleted = false;
            parts.add(part);
        }
        if (fileSize % partSize > 0L) {
            UploadPart part = new UploadPart();
            part.number = parts.size() + 1;
            part.offset = (long)parts.size() * partSize;
            part.size = fileSize % partSize;
            part.isCompleted = false;
            parts.add(part);
        }
        return parts;
    }

    private boolean remove(String filePath) {
        boolean flag = false;
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    class Task
    implements Callable<PartResult> {
        private int id;
        private String name;
        private UploadCheckPoint uploadCheckPoint;
        private int partIndex;
        private UploadFileRequest uploadFileRequest;
        private OSSMultipartOperation multipartOperation;
        private ProgressListener progressListener;

        public Task(int id, String name, UploadCheckPoint uploadCheckPoint, int partIndex, UploadFileRequest uploadFileRequest, OSSMultipartOperation multipartOperation, ProgressListener progressListener) {
            this.id = id;
            this.name = name;
            this.uploadCheckPoint = uploadCheckPoint;
            this.partIndex = partIndex;
            this.uploadFileRequest = uploadFileRequest;
            this.multipartOperation = multipartOperation;
            this.progressListener = progressListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartResult call() throws Exception {
            PartResult tr = null;
            InputStream instream = null;
            try {
                int limit;
                UploadPart uploadPart = this.uploadCheckPoint.uploadParts.get(this.partIndex);
                tr = new PartResult(this.partIndex + 1, uploadPart.offset, uploadPart.size);
                instream = new FileInputStream(this.uploadCheckPoint.uploadFile);
                instream.skip(uploadPart.offset);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(this.uploadFileRequest.getBucketName());
                uploadPartRequest.setKey(this.uploadFileRequest.getKey());
                uploadPartRequest.setUploadId(this.uploadCheckPoint.uploadID);
                uploadPartRequest.setPartNumber(uploadPart.number);
                uploadPartRequest.setInputStream(instream);
                uploadPartRequest.setPartSize(uploadPart.size);
                Payer payer = this.uploadFileRequest.getRequestPayer();
                if (payer != null) {
                    uploadPartRequest.setRequestPayer(payer);
                }
                if ((limit = this.uploadFileRequest.getTrafficLimit()) > 0) {
                    uploadPartRequest.setTrafficLimit(limit);
                }
                UploadPartResult uploadPartResult = OSSUploadOperation.this.uploadPartWrap(this.uploadCheckPoint, uploadPartRequest);
                if (this.multipartOperation.getInnerClient().getClientConfiguration().isCrcCheckEnabled()) {
                    OSSUtils.checkChecksum(uploadPartResult.getClientCRC(), uploadPartResult.getServerCRC(), uploadPartResult.getRequestId());
                    tr.setPartCRC(uploadPartResult.getClientCRC());
                    tr.setLength(uploadPartResult.getPartSize());
                    uploadPart.crc = uploadPartResult.getClientCRC();
                }
                PartETag partETag = new PartETag(uploadPartResult.getPartNumber(), uploadPartResult.getETag());
                this.uploadCheckPoint.update(this.partIndex, partETag, true);
                if (this.uploadFileRequest.isEnableCheckpoint()) {
                    this.uploadCheckPoint.dump(this.uploadFileRequest.getCheckpointFile());
                }
                ProgressPublisher.publishRequestBytesTransferred(this.progressListener, uploadPart.size);
            }
            catch (Exception e) {
                tr.setFailed(true);
                tr.setException(e);
                LogUtils.logException(String.format("Task %d:%s upload part %d failed: ", this.id, this.name, this.partIndex + 1), e);
            }
            finally {
                if (instream != null) {
                    instream.close();
                }
            }
            return tr;
        }
    }

    static class PartResult {
        private int number;
        private long offset;
        private long length;
        private boolean failed;
        private Exception exception;
        private Long partCRC;

        public PartResult(int number, long offset, long length) {
            this.number = number;
            this.offset = offset;
            this.length = length;
        }

        public PartResult(int number, long offset, long length, long partCRC) {
            this.number = number;
            this.offset = offset;
            this.length = length;
            this.partCRC = partCRC;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void setFailed(boolean failed) {
            this.failed = failed;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Long getPartCRC() {
            return this.partCRC;
        }

        public void setPartCRC(Long partCRC) {
            this.partCRC = partCRC;
        }
    }

    static class UploadPart
    implements Serializable {
        private static final long serialVersionUID = 6692863980224332199L;
        public int number;
        public long offset;
        public long size;
        public boolean isCompleted;
        public long crc;

        UploadPart() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isCompleted ? 1231 : 1237);
            result = 31 * result + this.number;
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            result = 31 * result + (int)(this.crc ^ this.crc >>> 32);
            return result;
        }
    }

    static class FileStat
    implements Serializable {
        private static final long serialVersionUID = -1223810339796425415L;
        public long size;
        public long lastModified;
        public String digest;

        FileStat() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.digest == null ? 0 : this.digest.hashCode());
            result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            return result;
        }

        public static FileStat getFileStat(String uploadFile) {
            FileStat fileStat = new FileStat();
            File file = new File(uploadFile);
            fileStat.size = file.length();
            fileStat.lastModified = file.lastModified();
            return fileStat;
        }
    }

    static class UploadCheckPoint
    implements Serializable {
        private static final long serialVersionUID = 5424904565837227164L;
        private static final String UPLOAD_MAGIC = "FE8BB4EA-B593-4FAC-AD7A-2459A36E2E62";
        public String magic;
        public int md5;
        public String uploadFile;
        public FileStat uploadFileStat;
        public String key;
        public String uploadID;
        public ArrayList<UploadPart> uploadParts;
        public ArrayList<PartETag> partETags;
        public long originPartSize;

        UploadCheckPoint() {
        }

        public synchronized void load(String cpFile) throws IOException, ClassNotFoundException {
            FileInputStream fileIn = new FileInputStream(cpFile);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            UploadCheckPoint ucp = (UploadCheckPoint)in.readObject();
            this.assign(ucp);
            in.close();
            fileIn.close();
        }

        public synchronized void dump(String cpFile) throws IOException {
            this.md5 = this.hashCode();
            FileOutputStream fileOut = new FileOutputStream(cpFile);
            ObjectOutputStream outStream = new ObjectOutputStream(fileOut);
            outStream.writeObject(this);
            outStream.close();
            fileOut.close();
        }

        public synchronized void update(int partIndex, PartETag partETag, boolean completed) throws IOException {
            this.partETags.add(partETag);
            this.uploadParts.get((int)partIndex).isCompleted = completed;
        }

        public synchronized boolean isValid(String uploadFile) {
            if (this.magic == null || !this.magic.equals(UPLOAD_MAGIC) || this.md5 != this.hashCode()) {
                return false;
            }
            File upload = new File(uploadFile);
            if (!upload.exists()) {
                return false;
            }
            return this.uploadFile.equals(uploadFile) && this.uploadFileStat.size == upload.length() && this.uploadFileStat.lastModified == upload.lastModified();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.magic == null ? 0 : this.magic.hashCode());
            result = 31 * result + (this.partETags == null ? 0 : this.partETags.hashCode());
            result = 31 * result + (this.uploadFile == null ? 0 : this.uploadFile.hashCode());
            result = 31 * result + (this.uploadFileStat == null ? 0 : this.uploadFileStat.hashCode());
            result = 31 * result + (this.uploadID == null ? 0 : this.uploadID.hashCode());
            result = 31 * result + (this.uploadParts == null ? 0 : this.uploadParts.hashCode());
            result = 31 * result + (int)this.originPartSize;
            return result;
        }

        public void assign(UploadCheckPoint ucp) {
            this.magic = ucp.magic;
            this.md5 = ucp.md5;
            this.uploadFile = ucp.uploadFile;
            this.uploadFileStat = ucp.uploadFileStat;
            this.key = ucp.key;
            this.uploadID = ucp.uploadID;
            this.uploadParts = ucp.uploadParts;
            this.partETags = ucp.partETags;
            this.originPartSize = ucp.originPartSize;
        }
    }
}

