/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx;

import com.alibaba.schedulerx.SchedulerxProperties;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.StringUtils;
import com.alibaba.schedulerx.service.JobSyncService;
import com.alibaba.schedulerx.service.ScheduledJobSyncConfigurer;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.springscheduling.NoOpScheduler;
import com.alibaba.schedulerx.worker.processor.springscheduling.SchedulerxAnnotationBeanPostProcessor;
import com.alibaba.schedulerx.worker.processor.springscheduling.SchedulerxSchedulingConfigurer;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SchedulerxWorker.class})
@ConditionalOnProperty(prefix="spring.schedulerx2", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SchedulerxProperties.class})
public class SchedulerxAutoConfigure {
    private static final Logger LOGGER = LogFactory.getLogger(SchedulerxAutoConfigure.class);
    @Autowired
    private SchedulerxProperties properties;

    @Bean
    public JobSyncService jobSyncService() {
        return new JobSyncService();
    }

    @PostConstruct
    public void syncJobs() throws Exception {
        if (!this.properties.getJobs().isEmpty()) {
            LOGGER.info("spring.schedulerx2.jobs is not empty, start to sync jobs...");
            this.jobSyncService().syncJobs();
            LOGGER.info("sync jobs finished.");
        }
    }

    @Bean(value={"taskScheduler"})
    @ConditionalOnProperty(prefix="spring.schedulerx2.task.scheduling", name={"scheduler"}, havingValue="schedulerx")
    public NoOpScheduler noOpScheduler() {
        return new NoOpScheduler();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.schedulerx2.task.scheduling", name={"scheduler"}, havingValue="schedulerx")
    public SchedulerxSchedulingConfigurer schedulerxSchedulingConfigurer() {
        return new SchedulerxSchedulingConfigurer();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.schedulerx2.task.scheduling", name={"scheduler"}, havingValue="schedulerx")
    public SchedulerxAnnotationBeanPostProcessor schedulerxAnnotationBeanPostProcessor() {
        return new SchedulerxAnnotationBeanPostProcessor();
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.schedulerx2.task.scheduling", name={"sync"}, havingValue="true")
    public ScheduledJobSyncConfigurer scheduledJobSyncConfigurer() {
        return new ScheduledJobSyncConfigurer();
    }

    @Bean
    public SchedulerxWorker schedulerxWorker() {
        SchedulerxWorker schedulerxWorker = new SchedulerxWorker();
        schedulerxWorker.setDomainName(this.properties.getDomainName());
        schedulerxWorker.setGroupId(this.properties.getGroupId());
        schedulerxWorker.setEnableBatchWork(this.properties.isEnableBatchWork());
        schedulerxWorker.setDisableSites(this.properties.getDisableSites());
        schedulerxWorker.setEnableSites(this.properties.getEnableSites());
        schedulerxWorker.setDisableUnits(this.properties.getDisableUnits());
        schedulerxWorker.setEnableUnits(this.properties.getEnableUnits());
        schedulerxWorker.setAppKey(this.properties.getAppKey());
        schedulerxWorker.setAliyunAccessKey(this.properties.getAliyunAccessKey());
        schedulerxWorker.setAliyunSecretKey(this.properties.getAliyunSecretKey());
        schedulerxWorker.setNamespace(this.properties.getNamespace());
        schedulerxWorker.setHost(this.properties.getHost());
        schedulerxWorker.setPort(this.properties.getPort());
        schedulerxWorker.setEndpoint(this.properties.getEndpoint());
        schedulerxWorker.setNamespaceSource(this.properties.getNamespaceSource());
        schedulerxWorker.setMaxTaskBodySize(this.properties.getMaxTaskBodySize());
        schedulerxWorker.setBlockAppStart(this.properties.isBlockAppStart());
        schedulerxWorker.setSTSAccessKey(this.properties.getStsAccessKey());
        schedulerxWorker.setSTSSecretKey(this.properties.getStsSecretKey());
        schedulerxWorker.setSTSSecretToken(this.properties.getStsToken());
        schedulerxWorker.setSlsCollectorEnable(this.properties.isSlsCollectorEnable());
        schedulerxWorker.setShareContainerPool(this.properties.isShareContainerPool());
        schedulerxWorker.setThreadPoolMode(this.properties.getThreadPoolMode());
        schedulerxWorker.setLabel(this.properties.getLabel());
        schedulerxWorker.setLabelPath(this.properties.getLabelPath());
        if (this.properties.isShareContainerPool() || "all".equals(this.properties.getThreadPoolMode())) {
            schedulerxWorker.setSharePoolSize(this.properties.getSharePoolSize());
            schedulerxWorker.setSharePoolQueueSize(this.properties.getSharePoolQueueSize());
        }
        if (StringUtils.isNotEmpty((String)this.properties.getEndpointPort())) {
            schedulerxWorker.setEndpointPort(Integer.parseInt(this.properties.getEndpointPort()));
        }
        schedulerxWorker.setEnableCgroupMetrics(this.properties.isEnableCgroupMetrics());
        if (this.properties.isEnableCgroupMetrics()) {
            schedulerxWorker.setCgroupPathPrefix(this.properties.getCgroupPathPrefix());
        }
        if (StringUtils.isNotEmpty((String)this.properties.getNamespaceSource())) {
            schedulerxWorker.setNamespaceSource(this.properties.getNamespaceSource());
        }
        schedulerxWorker.setAkkaRemotingAutoRecover(this.properties.isAkkaRemotingAutoRecover());
        schedulerxWorker.setEnableHeartbeatLog(this.properties.isEnableHeartbeatLog());
        schedulerxWorker.setMapMasterStatusCheckInterval(this.properties.getMapMasterStatusCheckInterval());
        schedulerxWorker.setEnableSecondDelayCycleIntervalMs(this.properties.isEnableSecondDealyCycleIntervalMs());
        schedulerxWorker.setEnableMapMasterFailover(this.properties.isEnableMapMasterFailover());
        schedulerxWorker.setEnableSecondDelayStandaloneDispatch(this.properties.isEnableSecondDelayStandaloneDispatch());
        schedulerxWorker.setPageSize(this.properties.getPageSize());
        schedulerxWorker.setGraceShutdownTimeout(this.properties.getWorkerShutdownDelay());
        schedulerxWorker.setWorkerShutdownMode(this.properties.getWorkerShutdownMode());
        schedulerxWorker.setGraceShutdownMode(this.properties.getGraceShutdownMode());
        if (this.properties.getGraceShutdownTimeout() > 0L) {
            schedulerxWorker.setGraceShutdownTimeout(this.properties.getGraceShutdownTimeout());
        }
        schedulerxWorker.setBroadcastDispatchThreadNum(this.properties.getBroadcastDispatchThreadNum());
        schedulerxWorker.setBroadcastDispatchThreadEnable(Boolean.valueOf(this.properties.isBroadcastDispatchThreadEnable()));
        schedulerxWorker.setBroadcastMasterExecEnable(Boolean.valueOf(this.properties.isBroadcastMasterExecEnable()));
        schedulerxWorker.setBroadcastDispatchRetryTimes(this.properties.getBroadcastDispatchRetryTimes());
        schedulerxWorker.setProcessorPoolSize(this.properties.getProcessorPoolSize());
        schedulerxWorker.setMapMasterDispatchRandom(this.properties.isMapMasterDispatchRandom());
        schedulerxWorker.setMapMasterRouterStrategy(this.properties.getMapMasterRouterStrategy());
        if (StringUtils.isNotEmpty((String)this.properties.getH2DatabaseUser())) {
            schedulerxWorker.setH2DatabaseUser(this.properties.getH2DatabaseUser());
        }
        if (StringUtils.isNotEmpty((String)this.properties.getH2DatabasePassword())) {
            schedulerxWorker.setH2DatabasePassword(this.properties.getH2DatabasePassword());
        }
        schedulerxWorker.setHttpServerEnable(this.properties.getHttpServerEnable());
        schedulerxWorker.setHttpServerPort(this.properties.getHttpServerPort());
        ConfigUtil.getWorkerConfig().setProperty("stater.mode", (Object)"springboot");
        return schedulerxWorker;
    }
}

