/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx;

import com.alibaba.schedulerx.JobProperty;
import com.alibaba.schedulerx.common.domain.ContactInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.schedulerx2")
public class SchedulerxProperties {
    private String domainName;
    private String groupId;
    private String host;
    private int port = 0;
    private String enableUnits;
    private String disableUnits;
    private String enableSites;
    private String disableSites;
    private boolean enableBatchWork;
    private boolean enabled = true;
    private String appName;
    private String appKey;
    private String aliyunRamRole;
    private String aliyunAccessKey;
    private String aliyunSecretKey;
    private String stsAccessKey;
    private String stsSecretKey;
    private String stsToken;
    private String namespace;
    private String endpoint;
    private String endpointPort;
    private String namespaceName;
    private String namespaceSource;
    private int maxTaskBodySize = 65536;
    private boolean blockAppStart = true;
    private boolean slsCollectorEnable = true;
    private boolean shareContainerPool = false;
    private String threadPoolMode;
    private int sharePoolSize = 64;
    private int sharePoolQueueSize = Integer.MAX_VALUE;
    private String label;
    private String labelPath = "/etc/podinfo/annotations";
    private boolean enableCgroupMetrics = false;
    private String cgroupPathPrefix = "/sys/fs/cgroup/cpu/";
    private boolean akkaRemotingAutoRecover = true;
    private boolean enableHeartbeatLog = true;
    private int mapMasterStatusCheckInterval = 3000;
    private boolean enableSecondDealyCycleIntervalMs = false;
    private boolean enableMapMasterFailover = true;
    private boolean enableSecondDelayStandaloneDispatch = false;
    private int pageSize = 1000;
    @Deprecated
    private long workerShutdownDelay = 0L;
    @Deprecated
    private Integer workerShutdownMode;
    private String graceShutdownMode;
    private long graceShutdownTimeout = 0L;
    private int broadcastDispatchThreadNum = 4;
    private int broadcastDispatchRetryTimes = 1;
    private boolean broadcastDispatchThreadEnable = false;
    private boolean broadcastMasterExecEnable = true;
    private boolean mapMasterDispatchRandom = false;
    private Integer mapMasterRouterStrategy;
    private String regionId;
    private String h2DatabaseUser;
    private String h2DatabasePassword;
    private Boolean httpServerEnable;
    private Integer httpServerPort;
    private Map<String, JobProperty> jobs = new LinkedHashMap<String, JobProperty>();
    private String alarmChannel;
    private Map<String, ContactInfo> alarmUsers = new LinkedHashMap<String, ContactInfo>();
    private Map<String, Integer> processorPoolSize = new HashMap<String, Integer>();

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getEnableUnits() {
        return this.enableUnits;
    }

    public void setEnableUnits(String enableUnits) {
        this.enableUnits = enableUnits;
    }

    public String getDisableUnits() {
        return this.disableUnits;
    }

    public void setDisableUnits(String disableUnits) {
        this.disableUnits = disableUnits;
    }

    public String getEnableSites() {
        return this.enableSites;
    }

    public void setEnableSites(String enableSites) {
        this.enableSites = enableSites;
    }

    public String getDisableSites() {
        return this.disableSites;
    }

    public void setDisableSites(String disableSites) {
        this.disableSites = disableSites;
    }

    public boolean isEnableBatchWork() {
        return this.enableBatchWork;
    }

    public void setEnableBatchWork(boolean enableBatchWork) {
        this.enableBatchWork = enableBatchWork;
    }

    public String getAliyunAccessKey() {
        return this.aliyunAccessKey;
    }

    public void setAliyunAccessKey(String aliyunAccessKey) {
        this.aliyunAccessKey = aliyunAccessKey;
    }

    public String getAliyunSecretKey() {
        return this.aliyunSecretKey;
    }

    public void setAliyunSecretKey(String aliyunSecretKey) {
        this.aliyunSecretKey = aliyunSecretKey;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpointPort() {
        return this.endpointPort;
    }

    public void setEndpointPort(String endpointPort) {
        this.endpointPort = endpointPort;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public void setNamespaceName(String namespaceName) {
        this.namespaceName = namespaceName;
    }

    public String getNamespaceSource() {
        return this.namespaceSource;
    }

    public void setNamespaceSource(String namespaceSource) {
        this.namespaceSource = namespaceSource;
    }

    public int getMaxTaskBodySize() {
        return this.maxTaskBodySize;
    }

    public void setMaxTaskBodySize(int maxTaskBodySize) {
        this.maxTaskBodySize = maxTaskBodySize;
    }

    public boolean isBlockAppStart() {
        return this.blockAppStart;
    }

    public void setBlockAppStart(boolean blockAppStart) {
        this.blockAppStart = blockAppStart;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getStsAccessKey() {
        return this.stsAccessKey;
    }

    public void setStsAccessKey(String stsAccessKey) {
        this.stsAccessKey = stsAccessKey;
    }

    public String getStsSecretKey() {
        return this.stsSecretKey;
    }

    public void setStsSecretKey(String stsSecretKey) {
        this.stsSecretKey = stsSecretKey;
    }

    public String getStsToken() {
        return this.stsToken;
    }

    public String getAliyunRamRole() {
        return this.aliyunRamRole;
    }

    public void setAliyunRamRole(String aliyunRamRole) {
        this.aliyunRamRole = aliyunRamRole;
    }

    public void setStsToken(String stsToken) {
        this.stsToken = stsToken;
    }

    public boolean isSlsCollectorEnable() {
        return this.slsCollectorEnable;
    }

    public void setSlsCollectorEnable(boolean slsCollectorEnable) {
        this.slsCollectorEnable = slsCollectorEnable;
    }

    public boolean isShareContainerPool() {
        return this.shareContainerPool;
    }

    public void setShareContainerPool(boolean shareContainerPool) {
        this.shareContainerPool = shareContainerPool;
    }

    public int getSharePoolSize() {
        return this.sharePoolSize;
    }

    public void setSharePoolSize(int sharePoolSize) {
        this.sharePoolSize = sharePoolSize;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label != null && label.startsWith("#") && label.endsWith("#")) {
            String labelKey = label.substring(1, label.length() - 1);
            this.label = System.getenv(labelKey);
            return;
        }
        this.label = label;
    }

    public String getLabelPath() {
        return this.labelPath;
    }

    public void setLabelPath(String labelPath) {
        this.labelPath = labelPath;
    }

    public boolean isEnableCgroupMetrics() {
        return this.enableCgroupMetrics;
    }

    public void setEnableCgroupMetrics(boolean enableCgroupMetrics) {
        this.enableCgroupMetrics = enableCgroupMetrics;
    }

    public String getCgroupPathPrefix() {
        return this.cgroupPathPrefix;
    }

    public void setCgroupPathPrefix(String cgroupPathPrefix) {
        this.cgroupPathPrefix = cgroupPathPrefix;
    }

    public boolean isAkkaRemotingAutoRecover() {
        return this.akkaRemotingAutoRecover;
    }

    public void setAkkaRemotingAutoRecover(boolean akkaRemotingAutoRecover) {
        this.akkaRemotingAutoRecover = akkaRemotingAutoRecover;
    }

    public boolean isEnableHeartbeatLog() {
        return this.enableHeartbeatLog;
    }

    public void setEnableHeartbeatLog(boolean enableHeartbeatLog) {
        this.enableHeartbeatLog = enableHeartbeatLog;
    }

    public int getMapMasterStatusCheckInterval() {
        return this.mapMasterStatusCheckInterval;
    }

    public void setMapMasterStatusCheckInterval(int mapMasterStatusCheckInterval) {
        this.mapMasterStatusCheckInterval = mapMasterStatusCheckInterval;
    }

    public boolean isEnableSecondDealyCycleIntervalMs() {
        return this.enableSecondDealyCycleIntervalMs;
    }

    public void setEnableSecondDealyCycleIntervalMs(boolean enableSecondDealyCycleIntervalMs) {
        this.enableSecondDealyCycleIntervalMs = enableSecondDealyCycleIntervalMs;
    }

    public boolean isEnableMapMasterFailover() {
        return this.enableMapMasterFailover;
    }

    public void setEnableMapMasterFailover(boolean enableMapMasterFailover) {
        this.enableMapMasterFailover = enableMapMasterFailover;
    }

    public boolean isEnableSecondDelayStandaloneDispatch() {
        return this.enableSecondDelayStandaloneDispatch;
    }

    public void setEnableSecondDelayStandaloneDispatch(boolean enableSecondDelayStandaloneDispatch) {
        this.enableSecondDelayStandaloneDispatch = enableSecondDelayStandaloneDispatch;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Deprecated
    public long getWorkerShutdownDelay() {
        return this.workerShutdownDelay;
    }

    @Deprecated
    public void setWorkerShutdownDelay(long workerShutdownDelay) {
        this.workerShutdownDelay = workerShutdownDelay;
    }

    @Deprecated
    public Integer getWorkerShutdownMode() {
        return this.workerShutdownMode;
    }

    @Deprecated
    public void setWorkerShutdownMode(Integer workerShutdownMode) {
        this.workerShutdownMode = workerShutdownMode;
    }

    public String getGraceShutdownMode() {
        return this.graceShutdownMode;
    }

    public void setGraceShutdownMode(String graceShutdownMode) {
        this.graceShutdownMode = graceShutdownMode;
    }

    public long getGraceShutdownTimeout() {
        return this.graceShutdownTimeout;
    }

    public void setGraceShutdownTimeout(long graceShutdownTimeout) {
        this.graceShutdownTimeout = graceShutdownTimeout;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public Map<String, JobProperty> getJobs() {
        return this.jobs;
    }

    public void setJobs(Map<String, JobProperty> jobs) {
        this.jobs = jobs;
    }

    public String getAlarmChannel() {
        return this.alarmChannel;
    }

    public void setAlarmChannel(String alarmChannel) {
        this.alarmChannel = alarmChannel;
    }

    public Map<String, ContactInfo> getAlarmUsers() {
        return this.alarmUsers;
    }

    public void setAlarmUsers(Map<String, ContactInfo> alarmUsers) {
        this.alarmUsers = alarmUsers;
    }

    public int getBroadcastDispatchThreadNum() {
        return this.broadcastDispatchThreadNum;
    }

    public void setBroadcastDispatchThreadNum(int broadcastDispatchThreadNum) {
        this.broadcastDispatchThreadNum = broadcastDispatchThreadNum;
    }

    public boolean isBroadcastDispatchThreadEnable() {
        return this.broadcastDispatchThreadEnable;
    }

    public void setBroadcastDispatchThreadEnable(boolean broadcastDispatchThreadEnable) {
        this.broadcastDispatchThreadEnable = broadcastDispatchThreadEnable;
    }

    public String getThreadPoolMode() {
        return this.threadPoolMode;
    }

    public void setThreadPoolMode(String threadPoolMode) {
        this.threadPoolMode = threadPoolMode;
    }

    public Map<String, Integer> getProcessorPoolSize() {
        return this.processorPoolSize;
    }

    public void setProcessorPoolSize(Map<String, Integer> processorPoolSize) {
        this.processorPoolSize = processorPoolSize;
    }

    public int getSharePoolQueueSize() {
        return this.sharePoolQueueSize;
    }

    public void setSharePoolQueueSize(int sharePoolQueueSize) {
        this.sharePoolQueueSize = sharePoolQueueSize;
    }

    public boolean isMapMasterDispatchRandom() {
        return this.mapMasterDispatchRandom;
    }

    public void setMapMasterDispatchRandom(boolean mapMasterDispatchRandom) {
        this.mapMasterDispatchRandom = mapMasterDispatchRandom;
    }

    public boolean isBroadcastMasterExecEnable() {
        return this.broadcastMasterExecEnable;
    }

    public void setBroadcastMasterExecEnable(boolean broadcastMasterExecEnable) {
        this.broadcastMasterExecEnable = broadcastMasterExecEnable;
    }

    public int getBroadcastDispatchRetryTimes() {
        return this.broadcastDispatchRetryTimes;
    }

    public void setBroadcastDispatchRetryTimes(int broadcastDispatchRetryTimes) {
        this.broadcastDispatchRetryTimes = broadcastDispatchRetryTimes;
    }

    public Integer getMapMasterRouterStrategy() {
        return this.mapMasterRouterStrategy;
    }

    public void setMapMasterRouterStrategy(Integer mapMasterRouterStrategy) {
        this.mapMasterRouterStrategy = mapMasterRouterStrategy;
    }

    public String getH2DatabaseUser() {
        return this.h2DatabaseUser;
    }

    public void setH2DatabaseUser(String h2DatabaseUser) {
        this.h2DatabaseUser = h2DatabaseUser;
    }

    public String getH2DatabasePassword() {
        return this.h2DatabasePassword;
    }

    public void setH2DatabasePassword(String h2DatabasePassword) {
        this.h2DatabasePassword = h2DatabasePassword;
    }

    public Boolean getHttpServerEnable() {
        return this.httpServerEnable;
    }

    public void setHttpServerEnable(Boolean httpServerEnable) {
        this.httpServerEnable = httpServerEnable;
    }

    public Integer getHttpServerPort() {
        return this.httpServerPort;
    }

    public void setHttpServerPort(Integer httpServerPort) {
        this.httpServerPort = httpServerPort;
    }
}

