/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.service;

import com.alibaba.schedulerx.JobProperty;
import com.alibaba.schedulerx.SchedulerxProperties;
import com.alibaba.schedulerx.common.domain.ExecuteMode;
import com.alibaba.schedulerx.common.domain.JobType;
import com.alibaba.schedulerx.common.domain.Pair;
import com.alibaba.schedulerx.common.domain.TimeType;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.common.util.StringUtils;
import com.alibaba.schedulerx.scheduling.annotation.SchedulerX;
import com.alibaba.schedulerx.service.JobSyncService;
import com.alibaba.schedulerx.worker.domain.SpringScheduleProfile;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.springscheduling.SchedulerxSchedulingConfigurer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.IntervalTask;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.config.Task;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.CollectionUtils;

public class ScheduledJobSyncConfigurer
implements SchedulingConfigurer {
    private static final Logger LOGGER = LogFactory.getLogger(ScheduledJobSyncConfigurer.class);
    @Autowired
    private JobSyncService jobSyncService;
    @Autowired
    private SchedulerxProperties properties;
    @Autowired
    private SchedulerxSchedulingConfigurer schedulerxSchedulingConfigurer;
    @Value(value="${spring.schedulerx2.task.scheduling.overwrite:false}")
    private Boolean overwrite = false;
    @Value(value="${spring.schedulerx2.task.scheduling.model.default:broadcast}")
    private String defaultModel = ExecuteMode.BROADCAST.getKey();

    private boolean isValidModel(String mode) {
        if (mode == null) {
            return false;
        }
        return ExecuteMode.BROADCAST.getKey().equals(mode) || ExecuteMode.STANDALONE.getKey().equals(mode);
    }

    private JobProperty convertToJobProperty(Task task, Object target, Method method) {
        SchedulerX schedulerXMethod;
        JobProperty jobProperty = new JobProperty();
        Class targetClass = AopUtils.getTargetClass((Object)target);
        String jobName = targetClass.getSimpleName() + "_" + method.getName();
        String model = this.defaultModel;
        if (task != null && task instanceof CronTask) {
            String expression = ((CronTask)task).getExpression();
            jobProperty.setCron(expression);
        }
        if (task != null && task instanceof IntervalTask) {
            long interval = ((IntervalTask)task).getInterval() / 1000L;
            long l = interval = interval < 1L ? 1L : interval;
            if (interval < 60L) {
                jobProperty.setTimeType(TimeType.SECOND_DELAY.getValue());
            } else {
                jobProperty.setTimeType(TimeType.FIXED_RATE.getValue());
            }
            jobProperty.setTimeExpression(String.valueOf(interval));
        }
        if ((schedulerXMethod = (SchedulerX)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, SchedulerX.class)) != null) {
            if (StringUtils.isNotEmpty((String)schedulerXMethod.name())) {
                jobName = schedulerXMethod.name();
            }
            if (this.isValidModel(schedulerXMethod.model())) {
                model = schedulerXMethod.model();
            }
            if (StringUtils.isNotEmpty((String)schedulerXMethod.cron())) {
                jobProperty.setCron(schedulerXMethod.cron());
            }
            if (schedulerXMethod.fixedRate() > 0L) {
                long interval = schedulerXMethod.timeUnit().toSeconds(schedulerXMethod.fixedRate());
                long l = interval = interval < 1L ? 1L : interval;
                if (interval < 60L) {
                    jobProperty.setTimeType(TimeType.SECOND_DELAY.getValue());
                } else {
                    jobProperty.setTimeType(TimeType.FIXED_RATE.getValue());
                }
                jobProperty.setTimeExpression(String.valueOf(interval));
            }
        }
        jobProperty.setJobName(jobName);
        jobProperty.setJobType(JobType.SPRINGSCHEDULE.getKey());
        jobProperty.setJobModel(model);
        SpringScheduleProfile profile = new SpringScheduleProfile();
        profile.setClassName(targetClass.getName());
        profile.setMethod(method.getName());
        jobProperty.setContent(JsonUtil.toJson((Object)profile));
        jobProperty.setOverwrite(this.overwrite);
        return jobProperty;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        LOGGER.info("spring scheduled job is not empty, start to sync jobs...");
        try {
            Collection schedulerXTasks;
            JobProperty jobProperty;
            ScheduledMethodRunnable runnable;
            HashMap<String, JobProperty> jobs = new HashMap<String, JobProperty>();
            if (!CollectionUtils.isEmpty((Collection)taskRegistrar.getCronTaskList())) {
                for (CronTask cronTask : taskRegistrar.getCronTaskList()) {
                    if (!(cronTask.getRunnable() instanceof ScheduledMethodRunnable)) continue;
                    runnable = (ScheduledMethodRunnable)cronTask.getRunnable();
                    jobProperty = this.convertToJobProperty((Task)cronTask, runnable.getTarget(), runnable.getMethod());
                    jobs.put(jobProperty.getJobName(), jobProperty);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)taskRegistrar.getFixedDelayTaskList())) {
                for (IntervalTask intervalTask : taskRegistrar.getFixedDelayTaskList()) {
                    if (!(intervalTask.getRunnable() instanceof ScheduledMethodRunnable)) continue;
                    runnable = (ScheduledMethodRunnable)intervalTask.getRunnable();
                    jobProperty = this.convertToJobProperty((Task)intervalTask, runnable.getTarget(), runnable.getMethod());
                    jobs.put(jobProperty.getJobName(), jobProperty);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)taskRegistrar.getFixedRateTaskList())) {
                for (IntervalTask intervalTask : taskRegistrar.getFixedRateTaskList()) {
                    if (!(intervalTask.getRunnable() instanceof ScheduledMethodRunnable)) continue;
                    runnable = (ScheduledMethodRunnable)intervalTask.getRunnable();
                    jobProperty = this.convertToJobProperty((Task)intervalTask, runnable.getTarget(), runnable.getMethod());
                    jobs.put(jobProperty.getJobName(), jobProperty);
                }
            }
            if ((schedulerXTasks = this.schedulerxSchedulingConfigurer.getSchedulerXTaskTargets()) != null && schedulerXTasks.size() > 0) {
                for (Pair task : schedulerXTasks) {
                    jobProperty = this.convertToJobProperty(null, task.getFirst(), (Method)task.getSecond());
                    jobs.put(jobProperty.getJobName(), jobProperty);
                }
            }
            this.jobSyncService.syncJobs(jobs, this.properties.getNamespaceSource());
            LOGGER.info("spring scheduled job is not empty, sync jobs finished.");
        }
        catch (Exception e) {
            LOGGER.info("spring scheduled job is not empty, sync jobs failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

