/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.service;

import com.alibaba.schedulerx.JobProperty;
import com.alibaba.schedulerx.SchedulerxProperties;
import com.alibaba.schedulerx.common.domain.JobType;
import com.alibaba.schedulerx.common.domain.TimeType;
import com.alibaba.schedulerx.common.sdk.common.MonitorConfig;
import com.alibaba.schedulerx.common.util.CronExpression;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.common.util.StringUtils;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.InstanceProfileCredentialsProvider;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.schedulerx2.model.v20190430.CreateAppGroupRequest;
import com.aliyuncs.schedulerx2.model.v20190430.CreateAppGroupResponse;
import com.aliyuncs.schedulerx2.model.v20190430.CreateJobRequest;
import com.aliyuncs.schedulerx2.model.v20190430.CreateJobResponse;
import com.aliyuncs.schedulerx2.model.v20190430.CreateNamespaceRequest;
import com.aliyuncs.schedulerx2.model.v20190430.CreateNamespaceResponse;
import com.aliyuncs.schedulerx2.model.v20190430.GetJobInfoRequest;
import com.aliyuncs.schedulerx2.model.v20190430.GetJobInfoResponse;
import com.aliyuncs.schedulerx2.model.v20190430.UpdateJobRequest;
import com.aliyuncs.schedulerx2.model.v20190430.UpdateJobResponse;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobSyncService {
    private static final Logger LOGGER = LogFactory.getLogger(JobSyncService.class);
    private static final String NAMESPACE_SOURCE_SPRINGBOOT = "springboot";
    @Autowired
    private SchedulerxProperties properties;

    public void syncJobs() throws Exception {
        DefaultAcsClient client = null;
        DefaultProfile.addEndpoint((String)this.properties.getRegionId(), (String)"schedulerx2", (String)"schedulerx.aliyuncs.com");
        if (StringUtils.isNotEmpty((String)this.properties.getAliyunRamRole())) {
            DefaultProfile profile = DefaultProfile.getProfile((String)this.properties.getRegionId());
            InstanceProfileCredentialsProvider provider = new InstanceProfileCredentialsProvider(this.properties.getAliyunRamRole());
            client = new DefaultAcsClient((IClientProfile)profile, (AlibabaCloudCredentialsProvider)provider);
        } else {
            DefaultProfile defaultProfile = DefaultProfile.getProfile((String)this.properties.getRegionId(), (String)this.properties.getAliyunAccessKey(), (String)this.properties.getAliyunSecretKey());
            client = new DefaultAcsClient((IClientProfile)defaultProfile);
        }
        if (this.syncNamespace(client)) {
            if (this.syncAppGroup(client)) {
                for (Map.Entry<String, JobProperty> entry : this.properties.getJobs().entrySet()) {
                    String jobName = entry.getKey();
                    JobProperty jobProperty = entry.getValue();
                    GetJobInfoResponse.Data.JobConfigInfo jobConfigInfo = this.getJob(client, jobName);
                    if (jobConfigInfo == null) {
                        this.createJob(client, jobName, jobProperty);
                        continue;
                    }
                    if (!jobProperty.isOverwrite()) continue;
                    this.updateJob(client, jobConfigInfo, jobProperty);
                }
            }
            this.properties.setNamespaceSource(NAMESPACE_SOURCE_SPRINGBOOT);
        }
    }

    public boolean syncNamespace(DefaultAcsClient client) throws Exception {
        if (StringUtils.isEmpty((String)this.properties.getNamespace())) {
            LOGGER.error("please set spring.schedulerx2.namespace");
            throw new IOException("please set spring.schedulerx2.namespace");
        }
        if (StringUtils.isEmpty((String)this.properties.getNamespaceName())) {
            LOGGER.error("please set spring.schedulerx2.namespaceName");
            throw new IOException("please set spring.schedulerx2.namespaceName");
        }
        CreateNamespaceRequest request = new CreateNamespaceRequest();
        request.setUid(this.properties.getNamespace());
        request.setName(this.properties.getNamespaceName());
        request.setSource(NAMESPACE_SOURCE_SPRINGBOOT);
        CreateNamespaceResponse response = (CreateNamespaceResponse)client.getAcsResponse((AcsRequest)request);
        if (response.getSuccess().booleanValue()) {
            LOGGER.info(JsonUtil.toJson((Object)response));
            return true;
        }
        throw new IOException(response.getMessage());
    }

    public boolean syncAppGroup(DefaultAcsClient client) throws Exception {
        CreateAppGroupResponse response;
        if (StringUtils.isEmpty((String)this.properties.getAppName())) {
            LOGGER.error("please set spring.schedulerx2.appName");
            throw new IOException("please set spring.schedulerx2.appName");
        }
        if (StringUtils.isEmpty((String)this.properties.getAppKey())) {
            LOGGER.error("please set spring.schedulerx2.appKey");
            throw new IOException("please set spring.schedulerx2.appKey");
        }
        if (StringUtils.isEmpty((String)this.properties.getGroupId())) {
            LOGGER.error("please set spring.schedulerx2.groupId");
            throw new IOException("please set spring.schedulerx2.groupId");
        }
        CreateAppGroupRequest request = new CreateAppGroupRequest();
        request.setNamespace(this.properties.getNamespace());
        request.setNamespaceSource(NAMESPACE_SOURCE_SPRINGBOOT);
        request.setAppName(this.properties.getAppName());
        request.setGroupId(this.properties.getGroupId());
        request.setAppKey(this.properties.getAppKey());
        if (StringUtils.isNotEmpty((String)this.properties.getAlarmChannel())) {
            MonitorConfig monitorConfig = new MonitorConfig();
            monitorConfig.setSendChannel(this.properties.getAlarmChannel());
            request.setMonitorConfigJson(JsonUtil.toJson((Object)monitorConfig));
        }
        if (!this.properties.getAlarmUsers().isEmpty()) {
            ArrayList contactInfos = Lists.newArrayList(this.properties.getAlarmUsers().values());
            request.setMonitorContactsJson(JsonUtil.toJson((Object)contactInfos));
        }
        if ((response = (CreateAppGroupResponse)client.getAcsResponse((AcsRequest)request)).getSuccess().booleanValue()) {
            LOGGER.info(JsonUtil.toJson((Object)response));
            return true;
        }
        throw new IOException(response.getMessage());
    }

    private GetJobInfoResponse.Data.JobConfigInfo getJob(DefaultAcsClient client, String jobName) throws Exception {
        GetJobInfoRequest request = new GetJobInfoRequest();
        request.setNamespace(this.properties.getNamespace());
        request.setNamespaceSource(NAMESPACE_SOURCE_SPRINGBOOT);
        request.setGroupId(this.properties.getGroupId());
        request.setJobId(Long.valueOf(0L));
        request.setJobName(jobName);
        GetJobInfoResponse response = (GetJobInfoResponse)client.getAcsResponse((AcsRequest)request);
        if (response.getSuccess().booleanValue()) {
            return response.getData().getJobConfigInfo();
        }
        return null;
    }

    private void createJob(DefaultAcsClient client, String jobName, JobProperty jobProperty) throws Exception {
        CreateJobRequest request = new CreateJobRequest();
        request.setNamespace(this.properties.getNamespace());
        request.setNamespaceSource(NAMESPACE_SOURCE_SPRINGBOOT);
        request.setGroupId(this.properties.getGroupId());
        request.setName(jobName);
        request.setParameters(jobProperty.getJobParameter());
        if (jobProperty.getJobType().equals(JobType.JAVA.getKey())) {
            request.setJobType("java");
            request.setClassName(jobProperty.getClassName());
        }
        if (jobProperty.getJobModel().equals("mapreduce")) {
            request.setExecuteMode("batch");
        } else {
            request.setExecuteMode(jobProperty.getJobModel());
        }
        if (StringUtils.isNotEmpty((String)jobProperty.getDescription())) {
            request.setDescription(jobProperty.getDescription());
        }
        if (StringUtils.isNotEmpty((String)jobProperty.getCron()) && StringUtils.isNotEmpty((String)jobProperty.getOneTime())) {
            throw new IOException("cron and oneTime shouldn't set together");
        }
        if (StringUtils.isNotEmpty((String)jobProperty.getCron())) {
            CronExpression cronExpression = new CronExpression(jobProperty.getCron());
            Date now = new Date();
            Date nextData = cronExpression.getTimeAfter(now);
            Date next2Data = cronExpression.getTimeAfter(nextData);
            if (nextData != null && next2Data != null) {
                int interval = (int)(next2Data.getTime() - nextData.getTime()) / 1000;
                if (interval < 60) {
                    request.setTimeType(Integer.valueOf(TimeType.SECOND_DELAY.getValue()));
                    request.setTimeExpression(String.valueOf(interval));
                } else {
                    request.setTimeType(Integer.valueOf(TimeType.CRON.getValue()));
                    request.setTimeExpression(jobProperty.getCron());
                }
            } else {
                request.setTimeType(Integer.valueOf(TimeType.CRON.getValue()));
                request.setTimeExpression(jobProperty.getCron());
            }
        } else if (StringUtils.isNotEmpty((String)jobProperty.getOneTime())) {
            request.setTimeType(Integer.valueOf(TimeType.ONE_TIME.getValue()));
            request.setTimeExpression(jobProperty.getOneTime());
        } else {
            request.setTimeType(Integer.valueOf(TimeType.API.getValue()));
        }
        request.setTimeoutEnable(Boolean.valueOf(true));
        request.setTimeoutKillEnable(Boolean.valueOf(true));
        request.setSendChannel("default");
        request.setFailEnable(Boolean.valueOf(true));
        request.setTimeout(Long.valueOf(3600L));
        request.setMaxAttempt(Integer.valueOf(3));
        request.setAttemptInterval(Integer.valueOf(30));
        CreateJobResponse response = (CreateJobResponse)client.getAcsResponse((AcsRequest)request);
        if (!response.getSuccess().booleanValue()) {
            throw new IOException("create schedulerx job failed, jobName=" + jobName + ", message=" + response.getMessage());
        }
        LOGGER.info("create schedulerx job successfully, jobId={}, jobName={}", new Object[]{response.getData().getJobId(), jobName});
    }

    private void updateJob(DefaultAcsClient client, GetJobInfoResponse.Data.JobConfigInfo jobConfigInfo, JobProperty jobProperty) throws Exception {
        String executeMode = jobProperty.getJobModel();
        if (jobProperty.getJobModel().equals("mapreduce")) {
            executeMode = "batch";
        }
        int timeType = TimeType.CRON.getValue();
        String timeExpression = null;
        if (StringUtils.isNotEmpty((String)jobProperty.getCron()) && StringUtils.isNotEmpty((String)jobProperty.getOneTime())) {
            throw new IOException("cron and oneTime shouldn't set together");
        }
        if (StringUtils.isNotEmpty((String)jobProperty.getCron())) {
            CronExpression cronExpression = new CronExpression(jobProperty.getCron());
            Date now = new Date();
            Date nextData = cronExpression.getTimeAfter(now);
            Date next2Data = cronExpression.getTimeAfter(nextData);
            if (nextData != null && next2Data != null) {
                int interval = (int)(next2Data.getTime() - nextData.getTime()) / 1000;
                if (interval < 60) {
                    timeType = TimeType.SECOND_DELAY.getValue();
                    timeExpression = String.valueOf(interval);
                } else {
                    timeType = TimeType.CRON.getValue();
                    timeExpression = jobProperty.getCron();
                }
            } else {
                timeType = TimeType.CRON.getValue();
                timeExpression = jobProperty.getCron();
            }
        } else if (StringUtils.isNotEmpty((String)jobProperty.getOneTime())) {
            timeType = TimeType.ONE_TIME.getValue();
            timeExpression = jobProperty.getOneTime();
        } else {
            timeType = TimeType.API.getValue();
        }
        boolean needUpdate = false;
        if (!(jobConfigInfo.getDescription().equals(jobProperty.getDescription()) && jobConfigInfo.getClassName().equals(jobProperty.getClassName()) && jobConfigInfo.getParameters().equals(jobProperty.getJobParameter()) && jobConfigInfo.getExecuteMode().equals(executeMode) && jobConfigInfo.getTimeConfig().getTimeType() == timeType && jobConfigInfo.getTimeConfig().getTimeExpression().equals(timeExpression))) {
            needUpdate = true;
            UpdateJobRequest request = new UpdateJobRequest();
            request.setNamespace(this.properties.getNamespace());
            request.setNamespaceSource(NAMESPACE_SOURCE_SPRINGBOOT);
            request.setGroupId(this.properties.getGroupId());
            request.setJobId(jobConfigInfo.getJobId());
            request.setName(jobConfigInfo.getName());
            request.setParameters(jobProperty.getJobParameter());
            if (jobProperty.getJobType().equals(JobType.JAVA.getKey())) {
                request.setClassName(jobProperty.getClassName());
            }
            request.setExecuteMode(executeMode);
            if (StringUtils.isNotEmpty((String)jobProperty.getDescription())) {
                request.setDescription(jobProperty.getDescription());
            }
            request.setTimeType(Integer.valueOf(timeType));
            request.setTimeExpression(timeExpression);
            request.setTimeoutEnable(Boolean.valueOf(true));
            request.setTimeoutKillEnable(Boolean.valueOf(true));
            request.setSendChannel("default");
            request.setFailEnable(Boolean.valueOf(true));
            request.setTimeout(Long.valueOf(3600L));
            request.setMaxAttempt(Integer.valueOf(3));
            request.setAttemptInterval(Integer.valueOf(30));
            UpdateJobResponse response = (UpdateJobResponse)client.getAcsResponse((AcsRequest)request);
            if (response.getSuccess().booleanValue()) {
                LOGGER.info("update schedulerx job successfully, jobId={}, jobName={}", new Object[]{jobConfigInfo.getJobId(), jobConfigInfo.getName()});
            } else {
                throw new IOException("update schedulerx job failed, jobName=" + jobConfigInfo.getName() + ", message=" + response.getMessage());
            }
        }
    }
}

