package com.alibaba.schedulerx.worker.batch;

import java.util.List;

import com.alibaba.schedulerx.protocol.Worker.ContainerReportTaskStatusRequest;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.MapTaskMaster;

/**
 * Batch report tasks statues,
 * for parallel job instance, will merge status reqs into one batch req then send to Active server leader;
 * for grid job instance, will merge status reqs into one batch req then batch update local h2 status.
 * @author yanxun on 2019/1/6.
 */
public class TMStatusReqHandler<T> extends BaseReqHandler<T> {
    private static final Logger LOGGER = LogFactory.getLogger(TMStatusReqHandler.class);

    @Override
    public void process(long jobInstanceId, List<T> reqs, String workerAddr) {
//        batchProcessSvc.submit(new BatchStatuesUpdateRunnable(jobInstanceId, (List<ContainerReportTaskStatusRequest>)reqs));
        List<ContainerReportTaskStatusRequest> statues = (List<ContainerReportTaskStatusRequest>)reqs;
        long startTime = System.currentTimeMillis();
        (taskMasterPool.get(jobInstanceId)).batchUpdateTaskStatues(statues);
        LOGGER.info("jobInstanceId={}, batch update status cost:{}ms, size:{}", jobInstanceId,
                System.currentTimeMillis() - startTime , statues.size());
    }

    public TMStatusReqHandler(long jobInstanceId, int coreBatchThreadNum, int maxBatchThreadNum,
                              int batchSize, ReqQueue<T> queue) {
        super(jobInstanceId, coreBatchThreadNum, maxBatchThreadNum, batchSize, queue,
            "TM-Batch-Statuses-Process-Thread-", "TM-Batch-Statues-Retrieve-Thread-");
        defaultSleepMs = 100;
    }

    private class BatchStatuesUpdateRunnable implements Runnable {
        private long jobInstanceId;
        private List<ContainerReportTaskStatusRequest> statues;
        BatchStatuesUpdateRunnable(long jobInstanceId, List<ContainerReportTaskStatusRequest> reqs) {
            this.jobInstanceId = jobInstanceId;
            this.statues = reqs;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                (taskMasterPool.get(jobInstanceId)).batchUpdateTaskStatues(statues);
                LOGGER.info("jobInstanceId={}, batch update status cost:{}ms, size:{}", jobInstanceId,
                        System.currentTimeMillis() - startTime , statues.size());
            } catch (Throwable e) {
                LOGGER.error(e);
            } finally {
                activeRunnableNum.decrementAndGet();
            }
        }
    }
}
