package com.alibaba.schedulerx.worker.container;


/**
 * ShutdownMode
 * @author yaohui
 * @create 2023/7/13 8:19 PM
 **/
public enum ShutdownMode {

    WAIT_ALL(0), WAIT_RUNNING(1), IMMEDIATE(2),
    ;

    private int value;

    ShutdownMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    public static ShutdownMode parseValue(int value) {
        ShutdownMode[] list = ShutdownMode.values();
        for (ShutdownMode s : list) {
            if (s.getValue() == value) {
                return s;
            }
        }
        throw new IllegalArgumentException("ShutdownMode value is invalid. value:" + value);
    }
}
