package com.alibaba.schedulerx.worker.domain;

/**
 *
 * @author xiaomeng.hxm
 */
public interface WorkerConstants {
    String WORKER_AKKA_JOB_INSTANCE_ROUTING = "job_instance_routing";
    String WORKER_AKKA_JOB_INSTANCE_ROUTING_PATH = "/user/" + "job_instance_routing";
    String WORKER_AKKA_CONTAINER_ROUTING = "container_routing";
    String WORKER_AKKA_CONTAINER_ROUTING_PATH = "/user/" + WORKER_AKKA_CONTAINER_ROUTING;
    String WORKER_AKKA_HEARTBEAT_ROUTING = "heartbeat_routing";
    String WORKER_AKKA_HEARTBEAT_ROUTING_PATH = "/user/" + WORKER_AKKA_HEARTBEAT_ROUTING;
    String WORKER_AKKA_TASK_ROUTING = "task_routing";
    String WORKER_AKKA_TASK_ROUTING_PATH = "/user/" + WORKER_AKKA_TASK_ROUTING;
    String WORKER_AKKA_LOG_ROUTING = "log_routing";
    String WORKER_AKKA_LOG_ROUTING_PATH = "/user/" + WORKER_AKKA_LOG_ROUTING;
    String AT_LEAST_ONCE_DELIVERY_ROUTING_NAME = "at_least_once_delivery_routing";
    String WORKER_AKKA_GUARANTINE_RECOVER_NAME = "guarantine_recover";
    String AKKA_REMOTING_AUTO_RECOVER = "akka.remoting.auto.recover";
    boolean AKKA_REMOTING_AUTO_RECOVER_DEFAULT = true;

    String WORKER_H2_FILE_PATH = "worker.h2.path";
    String APP_GROUP_ID = "app.groupId";
    String ALIYUN_ACESSKEY = "aliyun.accessKey";
    String ALIYUN_SECRETKEY = "aliyun.secretKey";
    String STS_ACESSKEY = "sts.accessKey";
    String STS_SECRETKEY = "sts.secretKey";
    String STS_TOKEN = "sts.token";
    String APPGROUP_NAME = "appgroup.name";
    String DAUTH_ACESSKEY = "dauth.accessKey";
    String DAUTH_SECRETKEY = "dauth.secretKey";
    String DAUTH_TENANATID = "dauth.tenantId";
    String WORKER_VERSION = "worker.version";
    String WORKER_CONTAINER_TYPE = "worker.container.type";
    String WORKER_EXECUTOR_PREFIX = "worker.executor.";
    String WORKER_MASTER_PREFIX = "worker.master.";
    String WORKER_DOMAIN_NAME = "domainName";
    String WORKER_SERVER_DISCOVERY = "worker.server.discovery";
    String WORKER_GROUP_DISCOVERY = "worker.group.discovery";
    String MAP_TASK_ROOT_NAME = "MAP_TASK_ROOT";
    String REDUCE_TASK_NAME = "REDUCE_TASK";
    String MAP_MASTER_PAGE_SIZE = "map.master.page.size";
    String WORKER_TIMER_TASKS = "worker.timer.tasks";
    int MAP_MASTER_PAGE_SIZE_DEFAULT = 100;
    String MAP_MASTER_QUEUE_SIZE = "map.master.queue.size";
    int MAP_MASTER_QUEUE_SIZE_DEFAULT = 10000;
    String MAP_MASTER_DISPATCHER_SIZE = "map.master.dispatcher.size";
    int MAP_MASTER_DISPATCHER_SIZE_DEFAULT = 5;
    int MAP_MASTER_DISPATCHER_SIZE_MAX = 200;
    String MAP_MASTER_RUNNING_THRESHOLD = "map.master.running.threshold";
    int MAP_MASTER_RUNNING_THRESHOLD_DEFAULT = 500 * 10000;
    String Map_MASTER_STATUS_CHECK_INTERVAL = "map.master.status.check.interval";
    int Map_MASTER_STATUS_CHECK_INTERVAL_DEFAULT = 3 * 1000; //默认间隔3秒
    String MAP_MASTER_FAILOVER_ENABLE = "map.master.failover.enable";
    String MAP_MASTER_DISPATCH_RANDOM = "map.master.dispatch.random";

    String MAP_MASTER_ROUTER_STRATEGY = "map.master.router.strategy";

    String SECOND_DELAY_INTERVAL_MS_ENABLE = "second.delay.interval.ms.enable";
    boolean SECOND_DELAY_INTERVAL_MS_ENABLE_DEFAULT = false;
    
    String LOG_COLLECTOR_ENABLE = "log.collector.enable";
    String LOCAL_LOG_COLLECTOR_DIR = "/tmp/logs/schedulerx/userlog";
    boolean LOG_COLLECTOR_ENABLE_DEFAULT = true;
    int CONSUMER_NUM_DEFAULT = 5;
    String TASK_BODY_SIZE_MAX = "task.body.size.max";
    int TASK_BODY_SIZE_MAX_DEFAULT = 65536;
    int PARALLEL_TASK_LIST_SIZE_MAX = 300;
    int PARALLEL_TASK_LIST_SIZE_MAX_ADVANCED = 1000;
    int PULL_MODEL_TASK_SIZE_MAX = 10000;
    float USER_MEMORY_PERCENT_MAX = 0.9f;
    float USER_SPACE_PERCENT_MAX = 0.9f;
    float USER_LOAD_MAX = 8.0f;
    String HOSTNAME = "hostname";
    String PORT = "port";
    String DISABLE_UNITS = "disable.units";
    String DISABLE_SITES = "disable.sites";
    String ENABLE_UNITS = "enable.units";
    String ENABLE_SITES = "enable.sites";

    String BLOCK_APP_START = "block.app.start";
    boolean BLOCK_APP_START_DEFAULT = true;
    String BATCH_WORK_ENABLE = "batch.work.enable";
    boolean BATCH_WORK_ENABLE_DEFAULT = false;
    String WORKER_STARTER_MODE = "stater.mode";
    String SCHEDULERX_STARTER_MODE = "schedulerx.stater.mode";
    String WORKER_STARTER_MODE_DEFAULT = "java";
    String WORKER_STARTER_SPRING = "spring";
    String WORKER_STARTER_SPRINGBOOT = "springboot";
    String WORKER_STARTER_AGENT = "agent";
    String WORKER_STARTER_POD = "pod";

    String WORKER_JOBINSTANCE_ACTOR_NUM = "worker.jobinstance.actor.num";
    int WORKER_JOBINSTANCE_ACTOR_NUM_DEFAULT = 128;
    String WORKER_CONTAINER_ACTOR_NUM = "worker.container.actor.num";
    int WORKER_CONTAINER_ACTOR_NUM_DEFAULT = 256;
    String WORKER_HEARTBEAT_ACTOR_NUM = "worker.heartbeat.actor.num";
    int WORKER_HEARTBEAT_ACTOR_NUM_DEFAULT = 2;
    String WORKER_TASK_ACTOR_NUM = "worker.task.actor.num";
    int WORKER_TASK_ACTOR_NUM_DEFAULT = 128;

    String WORKER_LOG_ACTOR_NUM = "worker.log.actor.num";
    int WORKER_LOG_ACTOR_NUM_DEFAULT = 100;
    String AT_LEAST_ONCE_DELIVERY_ACTOR_NUM = "at.least.once.delivery.actor.num";
    int AT_LEAST_ONCE_DELIVERY_ACTOR_DEFAULT = 100;

    String WORKER_JAR_FILE_DIR = "worker.jar.file.dir";
    String WORKER_JAR_FILE_DIR_DEFAULT = "/tmp/jar/schedulerx/";

    String WORKER_DOMAIN_PROPERTY = "schedulerx.console.domain";
    String WORKER_DOMAIN_DIAMOND = "com.alibaba.schedulerx.domain";
    // 对应namespace
    String TENANT_ID = "tenant.id";

    String WORKER_NAMESPACE = "schedulerx.namespace";
    String WORKER_NAMESPACE_SOURCE = "schedulerx.namespace.source";
    String WORKER_GROUPID = "schedulerx.groupId";
    String WORKER_APPKEY = "schedulerx.appKey";

    String WORKER_SOURCE = "schedulerx.worker.source";
    String WORKER_SOURCE_UNKNOWN = "unknown";
    String WORKER_SOURCE_EDAS = "edas";
    String WORKER_SOURCE_EDAS_SERVERLESS = "edas.serverless";
    String WORKER_SOURCE_EDAS_K8S = "edas.k8s";
    String WORKER_LABEL = "worker.label";
    String WORKER_LABEL_PATH = "worker.label.path";
//    String WORKER_HTTP_CONNECTION_TIMEOUT = "schedulerx.http.connection.timeout";
//    long WORKER_HTTP_CONNECTION_TIMEOUT_DEFAULT = 10000;

    String LOG_COLLECTOR_PREFIX = "log.collector.";
    String SLS_SEND_THREADS = "sls.send.threads";
    int SLS_SEND_THREADS_DEFAULT = 4;
    String SCHEDULERX_AUTHENTICATE_PREFIX = "schedulerx.authenticate.";

    String ADDRESS_SERVER_DOMAIN = "address.server.domain";
    String ADDRESS_SERVER_PORT = "address.server.port";
    String SLS_COLLECTOR_ENABLE = "sls.log.enable";

    String SHARE_CONTAINER_POOL = "share.container.pool";
    String SHARE_POOL_SIZE = "share.pool.size";
    int SHARE_POOL_SIZE_DEFAULT = 64;

    String SHARE_POOL_QUEUE_SIZE = "share.pool.queue.size";

    String THREAD_POOL_MODE = "thread.pool.mode";
    String THREAD_POOL_MODE_DEFAULT = "instance";
    String THREAD_POOL_MODE_JOB = "job";
    String THREAD_POOL_MODE_ALL = "all";

    String PROCESSOR_THREAD_POOL_SIZE = "processor.thread.pool.size";

    String HEARTBEAT_LOG_ENABLE = "schedulerx.heartbeat.log.enable";
    
    // agent key
    String GROUP_ID = "groupId";
    String APP_KEY = "appKey";
    String AGENT_ENDPOINT = "endpoint";
    String AGENT_ENDPOINT_PORT = "endpointPort";
    String AGENT_ALIYUN_ACCESS_KEY = "aliyunAccessKey";
    String AGENT_ALIYUN_SECRET_KEY = "aliyunSecretKey";
    String AGENT_NAMESPACE = "namespace";
    String AGENT_LABEL = "label";

    String CGROUP_MERTRICS_ENABLE = "cgroup.metrics.enable";
    boolean CGROUP_MERTRICS_ENABLE_DEFAULT = false;
    String CGROUP_PATH_PREFIX = "cgroup.path.prefix";
    String CGROUP_PATH_PREFIX_DEFAULT = "/sys/fs/cgroup/cpu/";

    String EDAS_ENV_KEY_FILE = "spas.identity";
    String DOCKER_CREDENTIAL_PATH = "/etc/instanceInfo";
    String DOCKER_ACCESS_KEY = "env_spas_accessKey";
    String DOCKER_SECRET_KEY = "env_spas_secretKey";
    String ACCESS_KEY = "accessKey";
    String SECRET_KEY = "secretKey";

    String SECOND_DELAY_STANDALONE_DISPATCH = "second_delay.standalone.dispatch";
    boolean SECOND_DELAY_STANDALONE_DISPATCH_DEFAULT = false;
    
    String WORKER_MAP_PAGE_SIZE = "worker.map.page.size";
    int WORKER_MAP_PAGE_SIZE_DEFAULT = 1000;

    @Deprecated
    String WORKER_SHUTDOWN_MODE = "worker.shutdown.mode";
    int WORKER_SHUTDOWN_MODE_DEFAULT = 2;

    String GRACE_SHUTDOWN_MODE = "grace.shutdown.mode";

    String GRACE_SHUTDOWN_TIMEOUT = "grace.shutdown.timeout";
    long GRACE_SHUTDOWN_TIMEOUT_DEFAULT = 0;

    //k8s
    String K8S_NAMESPACE_SCHEDULERX = "schedulerx";
    String K8S_CONFIGMAP_SCHEDULERX = "schedulerx-configmap";
    String K8S_NAMESPACE = "k8s.namespace";
    String K8S_NAMESPACE_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";

    String BROADCAST_DISPATCH_THREAD_NUM = "broadcast.dispatch.thread.num";
    String BROADCAST_DISPATCH_RETRY_TIMES = "broadcast.dispatch.retry.times";
    String BROADCAST_DISPATCH_THREAD_ENABLE = "broadcast.dispatch.thread.enable";
    String BROADCAST_MASTER_EXEC_ENABLE = "broadcast.master.exec.enable";
    //同步k8s任务实现类
    String SYNC_K8S_TASK = "sync.k8s.task.service.impl";

    // edas ecs 应用版本标-D参数
    String EDAS_DEPLOY_VERSION = "ALIBABA_DEPLOY_VERSION";
    // edas k8s 应用版本标环境变量
    String EDAS_PACKAGE_VERSION = "EDAS_PACKAGE_VERSION";
    // 当前label，区别于用户set进来的值
    String WORKER_CUR_LABEL = "worker.cur.label";

    String WORKER_NOT_RUNNING_MESSAGE = "WORKER_NOT_RUNNING:";

    String H2_DATABASE_USER_KEY = "h2.database.user";
    String H2_DATABASE_PASSWORD_KEY = "h2.database.password";

    String HTTP_SERVER_PORT = "worker.http.server.port";
    String HTTP_SERVER_ENABLE = "worker.http.server.enable";
}
