package com.alibaba.schedulerx.worker.listener;

import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.processor.ProcessResult;

/**
 * 执行线程监听器
 * @author yaohui
 * @create 2022/7/14 下午8:07
 **/
public interface ThreadContainerListener {

    /**
     * 加载条件
     * @return
     */
    boolean condition();

    /**
     * 前置处理
     * @param jobContext
     */
    void before(JobContext jobContext);

    /**
     * 后置处理
     * @param jobContext
     * @param result
     */
    void after(JobContext jobContext, ProcessResult result);

}
