package com.alibaba.schedulerx.worker.logcollector;

import com.alibaba.schedulerx.common.constants.CommonConstants;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

/**
 *
 * @author xiaomeng.hxm
 */
public class LogCollectorFactory {
    private volatile static LogCollector collector = null;
    private static final Logger LOGGER = LogFactory.getLogger(LogCollectorFactory.class);

//    public static LogCollector newCollector(JobContext context) {
//        return new LocalLogCollector(context.getScheduleTime().toString("yyyy-MM-dd"), context.getUniqueId());
//    }
//
//    public static LogCollector newCollector(String fireDate, String fileName) {
//        return new LocalLogCollector(fireDate, fileName);
//    }

    public static LogCleaner newCleaner() {
        return new LocalLogCleaner();
    }

    public static synchronized LogCollector get() {
        if (collector == null) {
            String logCollectorType = ConfigUtil.getWorkerConfig().getString(CommonConstants.LOG_COLLECTOR_TYPE,
                    CommonConstants.LOG_COLLECTOR_TYPE_DEFAULT);
            String className = ConfigUtil.getWorkerConfig().getString(WorkerConstants.LOG_COLLECTOR_PREFIX + logCollectorType,
                    DefaultLogCollector.class.getName());
            if (!ConfigUtil.getWorkerConfig().getBoolean(WorkerConstants.SLS_COLLECTOR_ENABLE, true)) {
                className = DefaultLogCollector.class.getName();
            }
            try {
                collector = ReflectionUtil.getInstanceByClassName(className, SchedulerxWorker.CUSTOMER_CLASS_LOADER);
            } catch (Throwable e) {
                LOGGER.error("", e);
                throw new RuntimeException(e);
            }
        }
        return collector;
    }

    public static synchronized LogCollector refresh() {
        String logCollectorType = ConfigUtil.getWorkerConfig().getString(CommonConstants.LOG_COLLECTOR_TYPE,
                CommonConstants.LOG_COLLECTOR_TYPE_DEFAULT);
        String className = ConfigUtil.getWorkerConfig().getString(WorkerConstants.LOG_COLLECTOR_PREFIX + logCollectorType,
                DefaultLogCollector.class.getName());
        if (!ConfigUtil.getWorkerConfig().getBoolean(WorkerConstants.SLS_COLLECTOR_ENABLE, true)) {
            className = DefaultLogCollector.class.getName();
        }
        try {
            collector = ReflectionUtil.getInstanceByClassName(className, SchedulerxWorker.CUSTOMER_CLASS_LOADER);
        } catch (Throwable e) {
            LOGGER.error("", e);
            throw new RuntimeException(e);
        }
        return collector;
    }
}
