package com.alibaba.schedulerx.worker.master;

import java.io.IOException;

import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.persistence.H2FilePersistence;
import com.alibaba.schedulerx.worker.util.SystemManagementUtil;

import akka.actor.ActorContext;

/**
 *
 * @author xiaomeng.hxm
 */
public class BatchTaskMaster extends GridTaskMaster {
    private static final Logger LOGGER = LogFactory.getLogger(BatchTaskMaster.class);

    public BatchTaskMaster(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        super(jobInstanceInfo, actorContext);
        this.taskPersistence = H2FilePersistence.getInstance();
        this.taskPersistence.initTable();
    }

    /**
     * Master各类指标信息检查
     */
    @Override
    protected void doMetricsCheck() throws IOException {
        float usedSpacePercent = SystemManagementUtil.getUserDiskSpacePercent();
        if (usedSpacePercent > WorkerConstants.USER_SPACE_PERCENT_MAX) {
            throw new IOException("disk usage:" + usedSpacePercent * 100 + ",beyond " + WorkerConstants.USER_SPACE_PERCENT_MAX * 100 + "%!");
        }
    }
}
