package com.alibaba.schedulerx.worker.master.persistence;

import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.protocol.Worker.ContainerReportTaskStatusRequest;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * @author yanxun on 2019/1/12.
 */
public class PersistenceUtil {
    /**
     * get task status classfied by status, workerIdAddr
     * @param taskStatusInfos
     * @return {status -> {workerIdAddr -> list of taskIds}}
     */
    public static Map<Integer, Map<String, List<Worker.TaskStatusInfo>>> getTaskStatusMap(List<ContainerReportTaskStatusRequest> taskStatusInfos) {
        Map<Integer, Map<String, List<Worker.TaskStatusInfo>>> status2WorkIdAddr2TaskIds = Maps.newHashMap();
        for (ContainerReportTaskStatusRequest e : taskStatusInfos) {
            Integer status = e.getStatus();
            Long taskId = e.getTaskId();
            String traceId = e.getTraceId();
            String workerIdAddr = e.getWorkerId() + "@" + e.getWorkerAddr();
            addTaskStatusInfo(status2WorkIdAddr2TaskIds, status, workerIdAddr, taskId, traceId);
        }
        return status2WorkIdAddr2TaskIds;
    }
    
    public static void addTaskStatusInfo(Map<Integer, Map<String, List<Worker.TaskStatusInfo>>> status2WorkIdAddr2TaskIds,
                                          Integer status, String workerIdAddr, Long taskId, String traceId) {
        Worker.TaskStatusInfo.Builder builder = Worker.TaskStatusInfo.newBuilder()
                .setTaskId(taskId)
                .setStatus(status);
        if (StringUtils.isNotBlank(traceId)) {
            builder.setTraceId(traceId);
        }
        Worker.TaskStatusInfo taskStatusInfo = builder.build();
        if (!status2WorkIdAddr2TaskIds.containsKey(status)) {
            // status not exists , all below must be first time add in too
            Map<String, List<Worker.TaskStatusInfo>> workerAddr2TaskIds = Maps.newHashMap();
            workerAddr2TaskIds.put(workerIdAddr, Lists.newArrayList(taskStatusInfo));
            status2WorkIdAddr2TaskIds.put(status, workerAddr2TaskIds);
        } else {
            // status already exists
            Map<String, List<Worker.TaskStatusInfo>> workerIdAddr2TaskIds = status2WorkIdAddr2TaskIds.get(status);
            if (!workerIdAddr2TaskIds.containsKey(workerIdAddr)) {
                workerIdAddr2TaskIds.put(workerIdAddr, Lists.newArrayList(taskStatusInfo));
            } else {
                workerIdAddr2TaskIds.get(workerIdAddr).add(taskStatusInfo);
            }
        }
    }
}
