package com.alibaba.schedulerx.worker.master.scheduler;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;

import com.alibaba.schedulerx.common.domain.EntryType;
import com.alibaba.schedulerx.common.domain.TriggerType;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.google.common.collect.Sets;
import org.joda.time.DateTime;

/**
* 按照调度时间+任务优先级排序的时间队列
* 
* @author xiaomeng.hxm
*/
public class TimeQueue {
    
    // 优先级队列，通过调度时间由小到大排序
    private Queue<TimePlanEntry> timeQueue = new PriorityBlockingQueue<>(100, new Comparator<TimePlanEntry>() {
        @Override
        public int compare(TimePlanEntry o1, TimePlanEntry o2) {
            return (int) (o1.getScheduleTimeStamp() - o2.getScheduleTimeStamp());
        }
    });
    //去重判断集合
    private Set<TimePlanEntry> timeSet = Sets.newConcurrentHashSet();
    
    private static final Logger LOGGER = LogFactory.getLogger(TimeQueue.class);
    
    public void add(TimePlanEntry timePlanEntry) {
        if (!timeSet.contains(timePlanEntry)) {
            if (timeSet.add(timePlanEntry)) {
                timeQueue.add(timePlanEntry);
                LOGGER.info("timeQueue add plan={}", timePlanEntry);
            } else {
                LOGGER.warn("plan={} is existed in timeQueue", timePlanEntry); 
            }
        } else {
            LOGGER.warn("plan={} is existed in timeQueue", timePlanEntry);
        }
    }
    
    public void remove(long jobInstanceId) {
        Iterator<TimePlanEntry> it = timeQueue.iterator();
        while (it.hasNext()) {
            TimePlanEntry planEntry = it.next();
            if (planEntry.getJobInstanceId() == jobInstanceId) {
                it.remove();
                timeSet.remove(planEntry);
                LOGGER.info("planEntry={} removed, event.getTriggerType()!=null", planEntry);
            }
        }
    }
    
    /**
     * Retrieves, but does not remove, the head of this queue, or returns null if this queue is empty.
     * @return the head of this queue, or null if this queue is empty
     */
    public TimePlanEntry peek() {
        return timeQueue.peek();
    }
    
    /**
     * Retrieves and removes the head of this queue. This method differs from poll only in that it throws an exception if this queue is empty.
     * @return the head of this queue
     */
    public TimePlanEntry remove() {
        TimePlanEntry planEntry = timeQueue.remove();
        timeSet.remove(planEntry);
        return planEntry;
    }
    
    public boolean isEmpty() {
        return timeQueue.isEmpty();
    }
    
    public int size() {
        return timeQueue.size();
    }
    
    public void clear() {
        timeQueue.clear();
        timeSet.clear();
    }
    
}
