package com.alibaba.schedulerx.worker.master.scheduler;

import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

/**
* 客户端时间调度器，主要用来做秒级别任务调度
* 
* @author xiaomeng.hxm
*/
public enum TimeScheduler {
	INSTANCE;
	
	private TimeQueue timeQueue = new TimeQueue();
	private TimeScanThread scanThread;
	private volatile boolean INITED = false;
	private static final Logger LOGGER = LogFactory.getLogger(TimeScheduler.class);
	
	public synchronized void init() {
		if (!INITED) {
			scanThread = new TimeScanThread("Schedulerx-TimeScanThread");
			scanThread.start();
			LOGGER.info("TimeScanThread started");
	        INITED = true;
		}
	}
	
	class TimeScanThread extends Thread {
        public TimeScanThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    long now = System.currentTimeMillis();
                    while (!timeQueue.isEmpty()) {
                        TimePlanEntry entry = timeQueue.peek();
                        if (entry != null && (entry.getScheduleTimeStamp() <= now)) {
                            LOGGER.info("{} time ready", entry);
                            // 1. remove this from planQueue
                            timeQueue.remove();
                            // 2. start this time based job
                            submitPlan(entry);
                        } else {
                            break;
                        }
                    }
                } catch (Exception e) {
                    LOGGER.error("", e);
                }

                try {
                    Thread.sleep(100);
                } catch (InterruptedException e) {
                    LOGGER.error("", e);
                }
            }
        }
    }
	
	public void add(TimePlanEntry entry) {
		timeQueue.add(entry);
	}
	
	public void remove(long jobInstanceId) {
		timeQueue.remove(jobInstanceId);
	}
	
	private void submitPlan(TimePlanEntry entry) {
		entry.getHandler().triggerNewCycle();
	}

}
