package com.alibaba.schedulerx.worker.processor;

import java.io.File;
import java.io.IOException;

import com.alibaba.schedulerx.worker.domain.JobContext;

import com.google.common.io.Files;
import org.apache.commons.lang.StringUtils;

/**
 *
 * @author xiaomeng.hxm
 */
public class PythonProcessor extends ShellProcessor {

    public static final String PYTHON_SCRIPT_PREFIX = System.getProperties().getProperty("user.home") + "/script/python/";
    private String fileName;

    @Override
    public void preProcess(JobContext context) throws Exception {
        super.preProcess(context);
        File dir = new File(PYTHON_SCRIPT_PREFIX);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        fileName = writePythonScript(context);
    }

    @Override
    protected String[] getContent(JobContext context) {
        String[] parameters;
        if (StringUtils.isNotEmpty(context.getShardingParameter())) {
            parameters = new String[2];
            parameters[0] = String.valueOf(context.getShardingId());
            parameters[1] = context.getShardingParameter();
        } else if (StringUtils.isNotEmpty(context.getInstanceParameters())) {
            parameters = context.getInstanceParameters().trim().split(" ");
        } else {
            parameters = context.getJobParameters().trim().split(" ");
        }
        String[] contents = new String[2 + parameters.length];
        contents[0] = "python";
        contents[1] = fileName;
        for (int i = 0; i < parameters.length; i++) {
            contents[2+i] = parameters[i];
        }
        return contents;
    }

    private String writePythonScript(JobContext context) throws IOException {
        //TODO 加入version
        long jobId = context.getJobId();
        String fileName = PYTHON_SCRIPT_PREFIX + "python_" + jobId + ".py";
        // add # -*- coding: utf-8 -*- to first line of python script file to make this file utf-8 encode.
        String content = parseContent(context);
        content = "# -*- coding: utf-8 -*-" + System.lineSeparator() + content;
        Files.write(content.getBytes(), new File(fileName));
        return fileName;
    }

}
