package com.alibaba.schedulerx.worker.processor;

import com.alibaba.schedulerx.common.domain.Pair;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.domain.SpringScheduleProfile;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.springscheduling.SchedulerxSchedulingConfigurer;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * SpringScheduleProcessor
 * @author yaohui
 * @create 2022/8/10 下午5:55
 **/
public class SpringScheduleProcessor extends JavaProcessor{

    private static final Logger logger = LogFactory.getLogger(SpringScheduleProcessor.class);

    private Object target;

    private Method method;

    public SpringScheduleProcessor(){}

    @Override
    public void init(String jobContent) {
        SchedulerxSchedulingConfigurer schedulingConfigurer = SchedulerxSchedulingConfigurer.getInstance();
        if (schedulingConfigurer == null) {
            logger.error("SpringScheduleProcessor init failed, has the SchedulingConfigurer been initialized.");
            throw new RuntimeException("SpringScheduleProcessor init failed, has the SchedulingConfigurer been initialized.");
        }
        try {
            SpringScheduleProfile profile = JsonUtil.fromJson(jobContent, SpringScheduleProfile.class);
            Pair<Object, Method> scheduledTaskTarget = schedulingConfigurer.getScheduledTaskTarget(profile.getClassName() + ":" + profile.getMethod());
            if (scheduledTaskTarget != null) {
                target = scheduledTaskTarget.getFirst();
                method = scheduledTaskTarget.getSecond();
            }
        } catch (Exception e) {
            logger.error("SpringScheduleProcessor init failed, check your job config.", e);
            throw new RuntimeException("SpringScheduleProcessor init failed, check your job config.", e);
        }
    }

    @Override
    public ProcessResult process(JobContext context) throws Exception {
        if (this.target == null || this.method == null) {
            return new ProcessResult(false, "Spring task bean method not found: " + context.getContent());
        }
        ReflectionUtils.makeAccessible(this.method);
        this.method.invoke(this.target);
        return new ProcessResult(true);
    }

    @Override
    public void kill(JobContext context) {}
}
