package com.alibaba.schedulerx.worker.route;

import com.alibaba.schedulerx.common.domain.RouteTargetNode;
import com.alibaba.schedulerx.common.domain.strategy.PercentStrategy;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.common.util.RouteUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;

import java.util.List;
import java.util.Map;

/**
 * @author dingxuan
 */
public class PercentRouter extends Router {

    private static final Map<String, Map<String, RouteTargetNode>> WORKER_ROUTE_TARGET_CAL_MAP = Maps.newConcurrentMap();

    private List<PercentStrategy> strategyList = Lists.newArrayList();

    @Override
    public void init(String strategyContent) {
        List<PercentStrategy> strategyListFromContent = JsonUtil.fromJson(strategyContent,
                new TypeToken<List<PercentStrategy>>(){}.getType());
        if (strategyListFromContent != null) {
            strategyList = strategyListFromContent;
        }

        initStrategyList();
    }

    @Override
    public String route(long appGroupId, long jobId, List<String> allWorkerList, Map<String, List<String>> targetWorkerAddrsMap, long loopCount, String masterWorkerIdAddr) {
        return getWorkerAddr(appGroupId, jobId, targetWorkerAddrsMap);
    }

    public String getWorkerAddr(long appGroupId, long jobId, Map<String, List<String>> targetWorkerAddrsMap) {
        if (targetWorkerAddrsMap.isEmpty()) {
            return null;
        }
        LOGGER.info("targetWorkerAddrsMap={}", targetWorkerAddrsMap);

        String key = IdUtil.getRouteStrategyUniqueId(appGroupId, jobId);
        Map<String, RouteTargetNode> map = WORKER_ROUTE_TARGET_CAL_MAP.get(key);
        if (map == null) {
            WORKER_ROUTE_TARGET_CAL_MAP.put(key, Maps.<String, RouteTargetNode>newConcurrentMap());
            map = WORKER_ROUTE_TARGET_CAL_MAP.get(key);
        }
        String target = RouteUtil.selectTarget(strategyList, map);
        LOGGER.info("target={}", target);
        List<String> workerAddrList = targetWorkerAddrsMap.get(target);
        if (workerAddrList == null || workerAddrList.isEmpty()) {
            return null;
        }

        int randomIndex = (int) (Math.random() * workerAddrList.size());
        return workerAddrList.get(randomIndex);
    }

    private void initStrategyList() {
        PercentStrategy leftPart = new PercentStrategy();
        if (strategyList.size() > 0) {
            leftPart.setTargetType(strategyList.get(0).getTargetType());
            leftPart.setTarget("[]");
            int leftPercentage = RouteUtil.TOTAL_WEIGHT;

            for (PercentStrategy strategy : strategyList) {
                leftPercentage -= strategy.getPercentage();
            }
            if (leftPercentage >= 0) {
                leftPart.setPercentage(leftPercentage);
                strategyList.add(leftPart);
            }
        }

    }
}
