package com.alibaba.schedulerx.worker.route;

import com.alibaba.schedulerx.common.domain.enums.RouteStrategyEnum;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * @author dingxuan
 */
public class RouterFactory {
    protected static final Logger LOGGER = LogManager.getLogger();
    private static RouterManager routerManager = RouterManager.INSTANCE;

    public static Router getRouter(long appGroupId, long jobId, int type, String content) {
        // 直接从map拿，拿到直接返回
        Router router = routerManager.getRouter(appGroupId, jobId);
        if (router != null) {
            return router;
        }

        // 没拿到就反射生成router, 放到map中
        router = buildRouter(type, content);
        routerManager.updateRouter(appGroupId, jobId, router);
        return router;
    }

    public static Router buildRouter(int type, String content) {
        Router router = null;
        String className = RouteStrategyEnum.routerClassName(type);
        try {
            router = ReflectionUtil.getInstanceByClassName(String.format(className, "worker"));
        } catch (ClassNotFoundException e) {
            LOGGER.error("class not found", e);
        } catch (Exception e) {
            LOGGER.error("", e);
        }
        if (router == null) {
            router = new RoundRobinRouter();
        }
        router.init(content);
        return router;
    }

//    public static Router getRouter(int type, String content) {
//        String className = RouteStrategyEnum.routerClassName(type);
//        Router router = null;
//        try {
//            router = ReflectionUtil.getInstanceByClassName(String.format(className, "worker"));
//        } catch (ClassNotFoundException e) {
//            LOGGER.error("class not found", e);
//        } catch (Exception e) {
//            LOGGER.error("", e);
//        }
//        if (router == null) {
//            router = new RoundRobinRouter();
//        }
//        if (content != null && !"".equals(content)) {
//            router.parseStrategyContent(content);
//        }
//        return router;
//    }


}
