package com.alibaba.schedulerx.worker.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.net.ssl.SSLContext;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.exception.AuthenticateException;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

/**
 *
 * @author xiaomeng.hxm
 */
public class DefaultAuthenticator implements Authenticator {
    private static final String AUTHENTICATE_URL = "/worker/v1/appgroup/authenticate";
//    private long connectionTimeout = ConfigUtil.getWorkerConfig().getLong(WorkerConstants.WORKER_HTTP_CONNECTION_TIMEOUT, 
//            WorkerConstants.WORKER_HTTP_CONNECTION_TIMEOUT_DEFAULT);
    private static final Logger LOGGER = LogFactory.getLogger(DefaultAuthenticator.class); 
    
    /**
     * 忽略ssl认证
     */
    static {
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext,
                SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            Unirest.setHttpClient(httpclient);
        } catch (Exception e) {
            LOGGER.error("", e);
        }
    }

    @Override
    public void authenticate(Configuration conf, String namespace, String namespaceSource, List<String> groupIds) 
            throws AuthenticateException {
        JSONResult result = JSONResult.geneFailResult();
        
        // -Dschedulerx.appKey优先
        String appKeyProperty = System.getProperty(WorkerConstants.WORKER_APPKEY);
        if (StringUtils.isNotBlank(appKeyProperty)) {
            conf.setProperty(WorkerConstants.APP_KEY, appKeyProperty);
        }
        
        String[] appKeys = conf.getStringArray(WorkerConstants.APP_KEY);
        if (appKeys.length <= 0) {
            throw new AuthenticateException("please set appKey for groupId=" + groupIds);
        }
        Map<String, Object> parameterMap = new HashMap<>();
        if (StringUtils.isNotBlank(namespace)) {
            parameterMap.put("namespace", namespace);
        }
        if (StringUtils.isNotBlank(namespaceSource)) {
            parameterMap.put("namespaceSource", namespaceSource);
        }
        parameterMap.put("groups", StringUtils.join(groupIds,","));
        parameterMap.put("accessKey", StringUtils.join(appKeys,","));
        parameterMap.put("type", "authenticate_default");
        String domain = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_DOMAIN_NAME);
        if (StringUtils.isNotBlank(domain)) {
            String url = "http://" + domain + AUTHENTICATE_URL;
            try {
//                Unirest.setTimeouts(connectionTimeout, 60000);
                HttpResponse<JsonNode> jsonResponse = Unirest.get(url).queryString(parameterMap).asJson();
                if (jsonResponse != null) {
                    result = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
                }
            } catch (UnirestException e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groupIds, url, e);
            } catch (Exception e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groupIds, url, e);
            }
        }
        
        if (result != null) {
            if (!result.isSuccess() || !(Boolean)result.getData()) {
                throw new AuthenticateException(result.getMessage()+ " domain=" + domain);
            }
        } else {
            throw new AuthenticateException("authenticate result is null");
        }
        
    }
}
