package com.alibaba.schedulerx.worker.service;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.container.ShutdownMode;

import java.util.Arrays;
import java.util.List;


/**
 * WorkerController
 * @author yaohui
 * @create 2023/8/11 4:51 PM
 **/
public class WorkerControlService {

    private static List<String> EXCLUDE_KEYS = Arrays.asList("sls.ak","sls.sk","sls.aksk.encoded","worker.timer.tasks");

    public JSONResult shutdown(Integer mode) {
        try {
            ShutdownMode shutdownMode = null;
            if (mode != null) {
                try {
                    shutdownMode = ShutdownMode.parseValue(mode);
                } catch (Exception e) {}
            }
            SchedulerxWorker.shutdown(shutdownMode);
            return JSONResult.geneSuccessResult("worker shutdown finished.", null);
        } catch (Throwable t) {
            return JSONResult.geneFailResult("worker shutdown failed.");
        }
    }

    public JSONResult restart() {
        try {
            SchedulerxWorker.restartActorSystem();
            return JSONResult.geneSuccessResult("worker shutdown restart.", null);
        } catch (Throwable t) {
            return JSONResult.geneFailResult("worker restart failed.");
        }
    }

    public JSONResult config() {
        try {
            Object data = ConfigUtil.toStringExclude(ConfigUtil.getWorkerConfig(), EXCLUDE_KEYS);
            return JSONResult.geneSuccessResult(data);
        } catch (Throwable t) {
            return JSONResult.geneFailResult("Get worker config failed.");
        }
    }
}
