package com.alibaba.schedulerx.worker.timer;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.util.FileUtils;
import org.apache.commons.lang.StringUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author dingxuan
 */
public class LabelFromEdasFetchTimer extends AbstractTimerTask {
    private static final String LABEL_KEY_IN_FILE = "alicloud.service.tag";

    @Override
    public String getName() {
        return "LabelFromEdasFetchTimer";
    }

    @Override
    public long getInitialDelay() {
        return 10;
    }

    @Override
    public long getPeriod() {
        return 10;
    }

    @Override
    public void run() {
        // 始终以用户设置的label为最高优先级
        if (StringUtils.isNotBlank(ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_LABEL))) {
            return;
        }
        // 先从环境变量取
        String labelFromEnv = System.getenv(WorkerConstants.EDAS_PACKAGE_VERSION);
        if (StringUtils.isNotBlank(labelFromEnv)) {
            ConfigUtil.getWorkerConfig().setProperty(WorkerConstants.WORKER_CUR_LABEL, labelFromEnv.trim().replace(" ", "_"));
            return;
        }

        // 环境变量没取到就从文件取
        String labelPath = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_LABEL_PATH);
        // 1. 判断worker中路径/etc/podinfo是否存在，不存在直接返回
        if (FileUtils.isExist(labelPath)) {
            // 2. 读取/etc/podinfo中annontation的内容
            String labelLine = FileUtils.readLine(labelPath, LABEL_KEY_IN_FILE);
            if (StringUtils.isNotBlank(labelLine)) {
                // 3. 获取key为alicloud.service.tag的value
                String labelFromFile = getLabel(labelLine);
                if (StringUtils.isNotBlank(labelFromFile)) {
                    // 4. 待心跳上报的时候赋值给label
                    ConfigUtil.getWorkerConfig().setProperty(WorkerConstants.WORKER_CUR_LABEL, labelFromFile.trim().replace(" ", "_"));
                    return;
                }
            }
        }

        // 都没获取到需要恢复用户之前设置的label值
        changeCurLabelToUserSetted();
    }

    private String getLabel(String labelLine) {
        String regex = LABEL_KEY_IN_FILE + "=\"(.*?)\"";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(labelLine);
        if (matcher.find()) {
            String label = matcher.group(1);
            return StringUtils.isNotBlank(label) ? label : null;
        }
        return null;
    }

    // 当文件中不存在版本标时，恢复至用户设置的label值
    private void changeCurLabelToUserSetted() {
        String labelSetByUser = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_LABEL);
        String curLabel = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_CUR_LABEL);
        if (StringUtils.isBlank(labelSetByUser)) {
            return;
        }
        if (!labelSetByUser.equalsIgnoreCase(curLabel)) {
            ConfigUtil.getWorkerConfig().setProperty(WorkerConstants.WORKER_CUR_LABEL, labelSetByUser);
        }
    }
}
