package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.common.constants.CommonConstants;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.IpUtil;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import org.apache.commons.lang.StringUtils;

/**
 * WORKER_ID = <pid>_<timestamp%100000>
 *
 * @author xiaomeng.hxm
 */
public class WorkerIdGenerator {

    private static String WORKER_ID;

    public static String get() {
        if (WORKER_ID == null) {
            synchronized (WorkerIdGenerator.class) {
                if (WORKER_ID == null) {
                    WORKER_ID = IpUtil.getFormatIpv4Address() + "_" + getNamespaceHashCode() + "_"
                        + System.currentTimeMillis() % 100000;
                }
            }
        }
        return WORKER_ID;
    }

    /**
     * 获取命名空间HashCode
     * @return
     */
    private static int getNamespaceHashCode() {
        // set优先
        String namespace = ConfigUtil.getWorkerConfig().getString(WorkerConstants.WORKER_NAMESPACE);
        if (StringUtils.isBlank(namespace)) {
            //从-D参数schedulerx.namespace获取
            namespace = System.getProperty(WorkerConstants.WORKER_NAMESPACE);
        }
        if (StringUtils.isBlank(namespace)) {
            // 然后再从-D参数tenant.id获取，兼容edas集成环境下命名规范
            namespace = System.getProperty(WorkerConstants.TENANT_ID);
        }
        if (StringUtils.isBlank(namespace)) {
            namespace = CommonConstants.DEFAULT_NAMESPACE_KEY;
        }
        return (namespace.hashCode() & Integer.MAX_VALUE) % 1000000;
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        System.out.println("WORKER_ID=" + get() + ", cost=" + (System.currentTimeMillis() - start) + "ms");
    }
}
