package com.alibaba.schedulerx.scheduling.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;

/**
 * schedulerx job annotation
 * @author yaohui
 * @create 2022/9/29 上午10:40
 **/
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface SchedulerX {

    /**
     * job name
     * @return
     */
    String name() default "";

    /**
     * execute model, only support (standalone, broadcast)
     * @return
     */
    String model() default "standalone";

    /**
     * cron expression
     * @return
     */
    String cron() default "";

    /**
     * time zone
     * @return
     */
    String zone() default "";

    /**
     * fixed rate (ms)
     * @return
     */
    long fixedRate() default -1L;

    /**
     * fixed rate time unit
     * @return
     */
    TimeUnit timeUnit() default TimeUnit.MILLISECONDS;

}
