package com.alibaba.schedulerx.worker.actor;

import java.util.List;

import org.apache.commons.configuration.Configuration;

import com.alibaba.schedulerx.common.constants.CommonConstants;
import com.alibaba.schedulerx.common.domain.LogReadResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.protocol.Server.ServerPushLogConfigRequest;
import com.alibaba.schedulerx.protocol.Server.ServerPushLogConfigResponse;
import com.alibaba.schedulerx.protocol.Server.ServerReadLogCharsRequest;
import com.alibaba.schedulerx.protocol.Server.ServerReadLogCharsResponse;
import com.alibaba.schedulerx.protocol.Server.ServerReadLogRequest;
import com.alibaba.schedulerx.protocol.Server.ServerReadLogResponse;
import com.alibaba.schedulerx.protocol.Server.ServerTailLogRequest;
import com.alibaba.schedulerx.protocol.Server.ServerTailLogResponse;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.log.appender.LogConfig;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.google.common.collect.Lists;

import akka.actor.UntypedActor;

/**
 *
 * @author xiaomeng.hxm
 */
public class LogActor extends UntypedActor {
    private static final Logger LOGGER = LogFactory.getLogger(LogActor.class);

    @Override
    public void onReceive(Object obj) throws Throwable {
        if (obj instanceof ServerTailLogRequest) {
            handleTailLog((ServerTailLogRequest) obj);
        } else if (obj instanceof ServerReadLogRequest) {
            handleReadLog((ServerReadLogRequest) obj);
        } else if (obj instanceof ServerReadLogCharsRequest) {
            handleReadLogChars((ServerReadLogCharsRequest) obj);
        } else if (obj instanceof ServerPushLogConfigRequest) {
            handlePushLogConfig((ServerPushLogConfigRequest) obj);
        }

    }

    private void handleTailLog(ServerTailLogRequest request) {
        ServerTailLogResponse response = null;
        try {
//            String uniqueId = IdUtil.getUniqueId(request.getJobId(), request.getJobInstanceId(), request.getTaskId());
//            String fireDate = new DateTime(request.getScheduleTime()).toString("yyyy-MM-dd");
//            LogCollector collector = LogCollectorFactory.newCollector(fireDate, uniqueId);
//            List<String> lines = collector.tailLines(request.getNum(), StreamType.STD_ERR);
            List<String> lines = Lists.newArrayList("not support");
            response = ServerTailLogResponse.newBuilder().setSuccess(true).addAllLine(lines).build();
        } catch (Throwable e) {
            LOGGER.error("", e);
            response = ServerTailLogResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
        } finally {
            getSender().tell(response, getSelf());
        }
    }

    private void handleReadLog(ServerReadLogRequest request) {
        ServerReadLogResponse response = null;
        try {
//            String uniqueId = IdUtil.getUniqueId(request.getJobId(), request.getJobInstanceId(), request.getTaskId());
//            String fireDate = new DateTime(request.getScheduleTime()).toString("yyyy-MM-dd");
//            LogCollector collector = LogCollectorFactory.newCollector(fireDate, uniqueId);
//            List<String> lines = collector.readLines(request.getOffset(), request.getSize(), StreamType.STD_ERR);
            List<String> lines = Lists.newArrayList("not support");
            response = ServerReadLogResponse.newBuilder()
                    .setSuccess(true)
                    .addAllLine(lines)
                    .setOffset(request.getOffset() + lines.size())
                    .setIsEnd(lines.isEmpty())
                    .build();
        } catch (Throwable e) {
            LOGGER.error("", e);
            response = ServerReadLogResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
        } finally {
            getSender().tell(response, getSelf());
        }
    }

    private void handleReadLogChars(ServerReadLogCharsRequest request) {
        ServerReadLogCharsResponse response = null;
        try {
//            String uniqueId = IdUtil.getUniqueId(request.getJobId(), request.getJobInstanceId(), request.getTaskId());
//            String fireDate = new DateTime(request.getScheduleTime()).toString("yyyy-MM-dd");
//            LogCollector collector = LogCollectorFactory.newCollector(fireDate, uniqueId);
//            LogReadResult logResult = collector.readChars(request.getOffset(), request.getSize(), StreamType.STD_ERR);
            LogReadResult logResult = new LogReadResult(true, "not support", 0);
            response = ServerReadLogCharsResponse.newBuilder()
                    .setSuccess(true)
                    .setLog(logResult.getLog())
                    .setOffset(logResult.getOffset())
                    .setIsEnd(logResult.isEnd())
                    .build();
        } catch (Throwable e) {
            LOGGER.error("", e);
            response = ServerReadLogCharsResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
        } finally {
            getSender().tell(response, getSelf());
        }
    }
    
    private void handlePushLogConfig(ServerPushLogConfigRequest request) {
        ServerPushLogConfigResponse response = null;
        try {
            LogConfig.INSTANCE.setEnable(request.getEnable());
            Configuration conf = ConfigUtil.getWorkerConfig();
            if (request.hasType()) {
                LogConfig.INSTANCE.setType(request.getType());
                conf.setProperty(CommonConstants.LOG_COLLECTOR_TYPE, request.getType());
                if (request.getType().equals("sls")) {
                    if (request.hasSlsAk() && request.hasSlsSk()) {
                        conf.setProperty(CommonConstants.SLS_AKSK_ENCODED, true);
                        conf.setProperty(CommonConstants.SLS_AK, request.getSlsAk());
                        conf.setProperty(CommonConstants.SLS_SK, request.getSlsSk());
                    }
                }
            }
            if (request.hasConfig()) {
                LogConfig.INSTANCE.setConfig(request.getConfig());
                conf.setProperty(CommonConstants.LOG_SERVICE_CONFIG, request.getConfig());
            }
            if (request.hasLevel()) {
                LogConfig.INSTANCE.setLevel(request.getLevel());
            }
            LogCollectorFactory.refresh();
            response = ServerPushLogConfigResponse.newBuilder().setSuccess(false).build();
        } catch (Exception e) {
            LOGGER.error("", e);
            response = ServerPushLogConfigResponse.newBuilder().setSuccess(false).setMessage(ExceptionUtil.getMessage(e)).build();
        } finally {
            getSender().tell(response, getSelf());
        }
    }
}
