package com.alibaba.schedulerx.worker.discovery;

import java.util.List;

import com.alibaba.schedulerx.worker.domain.WorkerConstants;

import com.google.common.collect.Lists;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

/**
 *
 * @author xiaomeng.hxm
 */
public class DefaultGroupDiscovery implements GroupDiscovery {

    @Override
    public List<String> getGroupIdList(Configuration conf) throws Exception {
        List<String> groupIdList = Lists.newArrayList();

        // 优先-D
        String groupIdProperty = System.getProperty(WorkerConstants.WORKER_GROUPID);
        if (StringUtils.isBlank(groupIdProperty)) {
            groupIdProperty = System.getenv(WorkerConstants.WORKER_GROUPID.replace(".", "_"));
        }
        if (StringUtils.isNotBlank(groupIdProperty)) {
            conf.setProperty(WorkerConstants.GROUP_ID, groupIdProperty);
        }
        String[] groupIds = conf.getStringArray(WorkerConstants.GROUP_ID);
        for (String groupId : groupIds) {
            String groupIdTrim = groupId.trim();
            if (!groupIdList.contains(groupIdTrim)) {
                groupIdList.add(groupId.trim());
            }
        }
        return groupIdList;
    }

    @Override
    public List<String> getAppKeyList(Configuration conf) throws Exception {
        List<String> appKeyList = Lists.newArrayList();

        // -Dschedulerx.appKey优先
        String appKeyProperty = System.getProperty(WorkerConstants.WORKER_APPKEY);
        if (StringUtils.isNotBlank(appKeyProperty)) {
            conf.setProperty(WorkerConstants.APP_KEY, appKeyProperty);
        }

        String[] appKeys = conf.getStringArray(WorkerConstants.APP_KEY);
        for (String appKey : appKeys) {
            String appKeyTrim = appKey.trim();
            if (!appKeyList.contains(appKeyTrim)) {
                appKeyList.add(appKeyTrim);
            }
        }
        return appKeyList;
    }

    @Override
    public boolean isSystemProperty() {
        String appKeyProperty = System.getProperty(WorkerConstants.WORKER_APPKEY);
        String groupIdProperty = System.getProperty(WorkerConstants.WORKER_GROUPID);
        if (StringUtils.isBlank(groupIdProperty)) {
            groupIdProperty = System.getenv(WorkerConstants.WORKER_GROUPID.replace(".", "_"));
        }
        return StringUtils.isNotBlank(appKeyProperty) || StringUtils.isNotBlank(groupIdProperty);
    }
}
