package com.alibaba.schedulerx.worker.domain;

/**
 *
 * @author xiaomeng.hxm
 */
public final class TaskInfo {
    private long jobId;
    private long jobInstanceId;
    private long taskId;
    private long batchNo;
    private String taskName;
    private byte[] taskBody;

    private TaskInfo() {}

    public long getTaskId() {
        return taskId;
    }

    public String getTaskName() {
        return taskName;
    }

    public byte[] getTaskBody() {
        return taskBody;
    }
    
    public long getJobId() {
        return jobId;
    }
    
    public long getJobInstanceId() {
        return jobInstanceId;
    }

    public long getBatchNo() {
        return batchNo;
    }

    public static TaskInfoBuilder newBuilder() {
        return new TaskInfoBuilder();
    }

    public static TaskInfoBuilder newBuilder(TaskInfo taskInfo) {
        return new TaskInfoBuilder(taskInfo);
    }

    public static final class TaskInfoBuilder {
        private TaskInfo taskInfo = new TaskInfo();

        private TaskInfoBuilder() {}

        private TaskInfoBuilder(TaskInfo taskInfo) {
            this.taskInfo = taskInfo;
        }

        public TaskInfoBuilder setTaskId(long taskId) {
            this.taskInfo.taskId = taskId;
            return this;
        }

        public TaskInfoBuilder setTaskName(String taskName) {
            this.taskInfo.taskName = taskName;
            return this;
        }

        public TaskInfoBuilder setTaskBody(byte[] taskBody) {
            this.taskInfo.taskBody = taskBody;
            return this;
        }
        
        public TaskInfoBuilder setJobId(long jobId) {
            this.taskInfo.jobId = jobId;
            return this;
        }
    
        public TaskInfoBuilder setJobInstanceId(long jobInstanceId) {
            this.taskInfo.jobInstanceId = jobInstanceId;
            return this;
        }

        public TaskInfoBuilder setBatchNo(long batchNo) {
            this.taskInfo.batchNo = batchNo;
            return this;
        }
        
        public TaskInfo build() {
            return taskInfo;
        }

    }
}
