package com.alibaba.schedulerx.worker.listener;

import com.alibaba.schedulerx.worker.container.ThreadContainer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

/**
 * 监听服务加载
 * @author yaohui
 * @create 2022/7/14 下午8:07
 **/
public class ListenerServiceLoader {

    public static final ListenerServiceLoader INSTANCE = new ListenerServiceLoader();

    private final Map<Class, Collection> listenerServiceMap = Maps.newHashMap();

    private ListenerServiceLoader() {
        try {
            ServiceLoader<ThreadContainerListener> listeners = ServiceLoader.load(ThreadContainerListener.class);
            Iterator<ThreadContainerListener> iterator = listeners.iterator();
            List<ThreadContainerListener> threadContainerListeners = Lists.newArrayList();
            while (iterator.hasNext()) {
                ThreadContainerListener obj = iterator.next();
                if (obj.condition()) {
                    threadContainerListeners.add(obj);
                }
            }
            listenerServiceMap.put(ThreadContainerListener.class, threadContainerListeners);
        } catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public <T> Collection<T> getListeners(Class<T> clazz) {
        return listenerServiceMap.get(clazz);
    }

}
