package com.alibaba.schedulerx.worker.log.appender;

import com.aliyun.openservices.aliyun.log.producer.Callback;
import com.aliyun.openservices.aliyun.log.producer.Result;
import com.aliyun.openservices.log.common.LogItem;
import org.apache.log4j.helpers.LogLog;

/**
 * @author xiaomeng.hxm
 *
 */
public class SchedulerxLog4jAppenderCallback implements Callback {
    private String project;

    private String logStore;

    private String topic;

    private String source;

    private LogItem logItem;

    public SchedulerxLog4jAppenderCallback(String project, String logStore, String topic, String source,
        LogItem logItem) {
      super();
      this.project = project;
      this.logStore = logStore;
      this.topic = topic;
      this.source = source;
      this.logItem = logItem;
    }

    @Override
    public void onCompletion(Result result) {
      if (!result.isSuccessful()) {
        LogLog.error(
            "Failed to send log, project=" + project
                + ", logStore=" + logStore
                + ", topic=" + topic
                + ", source=" + source
                + ", logItem=" + logItem
                + ", errorCode=" + result.getErrorCode()
                + ", errorMessage=" + result.getErrorMessage());
      }
    }
}
