package com.alibaba.schedulerx.worker.logcollector;

import org.apache.commons.lang.StringUtils;

import com.alibaba.schedulerx.common.domain.StreamType;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

/**
 * default log collector, write to clientInfo.log using log4j
 * 格式：唯一key（jobid_instanceid_taskid）|traceId(暂不支持)|内容|异常|本机host:port|
 *
 * @author xiaomeng.hxm
 */
public class DefaultLogCollector extends LogCollector {

    private static final Logger LOGGER = LogFactory.getLogger("clientInfo");
    private static final String LOGGER_FORMATTER = "{}|{}|{}|{}|{}";

    @Override
    public void collect(long appGroupId, String key, String line, Throwable t, StreamType streamType, boolean isEnd) {
        if (line != null) {
            String trace = (t == null ? StringUtils.EMPTY : ExceptionUtil.getTrace(t));
            if (streamType.equals(StreamType.STD_OUT)) {
                LOGGER.info(LOGGER_FORMATTER, key, StringUtils.EMPTY, line, trace, SchedulerxWorker.WORKER_ADDR);
            } else {
                LOGGER.error(LOGGER_FORMATTER, key, StringUtils.EMPTY, line, trace, SchedulerxWorker.WORKER_ADDR);
            }
        }
    }

}
