package com.alibaba.schedulerx.worker.logcollector;

import java.io.IOException;
import java.util.List;

import com.alibaba.schedulerx.common.domain.LogReadResult;
import com.alibaba.schedulerx.common.domain.StreamType;

/**
 *
 * @author xiaomeng.hxm
 */
public abstract class LogCollector {

    public static char END_OF_LOG = '\004';   //LOG结束符

    public void collect(long appGroupId, String key, String line) {
        collect(appGroupId, key, line, StreamType.STD_OUT, false);
    }

    public void collect(long appGroupId, String key, String line, Throwable t) {
        collect(appGroupId, key, line, t, StreamType.STD_ERR, false);
    }

    public void collect(long appGroupId, String key, String line, StreamType streamType, boolean isEnd) {
        collect(appGroupId, key, line, null, streamType, isEnd);
    }

    public abstract void collect(long appGroupId, String key, String line, Throwable t, StreamType streamType, boolean isEnd);

    public List<String> readLines(long lineOffset, int lineNumber, StreamType streamType) throws IOException {
        return null;
    }

    public LogReadResult readChars(long offset, int size, StreamType streamType) throws IOException {
        return null;
    }

    public List<String> tailLines(int lineNumber, StreamType streamType) throws IOException {
        return null;
    }

    public void delete() throws IOException {}

}
